/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BookContentLoader
implements ResourceManagerReloadListener,
IdentifiableResourceReloadListener {
    private static final FileToIdConverter ENTRY_FINDER = new FileToIdConverter("lavender/entries", ".md");
    private static final FileToIdConverter CATEGORY_FINDER = new FileToIdConverter("lavender/categories", ".md");
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().create();

    public static void initialize() {
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)new BookContentLoader());
    }

    public ResourceLocation getFabricId() {
        return Lavender.id("book_content_loader");
    }

    public void onResourceManagerReload(ResourceManager manager) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        BookContentLoader.reloadContents(manager);
    }

    public static void reloadContents(ResourceManager manager) {
        Map<String, Map<String, Resource>> entries = BookContentLoader.findResources(manager, ENTRY_FINDER);
        Map<String, Map<String, Resource>> categories = BookContentLoader.findResources(manager, CATEGORY_FINDER);
        for (Book book : BookLoader.allBooks()) {
            BookContentLoader.forResourceOfBook(categories, book, "category", (identifier, resource) -> {
                MarkdownResource markdown = BookContentLoader.parseMarkdown(book, identifier, resource);
                if (markdown == null) {
                    return;
                }
                String parentCategory = GsonHelper.getAsString((JsonObject)markdown.meta, (String)"parent", null);
                ResourceLocation parentCategoryId = parentCategory != null ? (parentCategory.indexOf(58) > 0 ? ResourceLocation.tryParse((String)parentCategory) : ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)parentCategory)) : null;
                book.addCategory(new Category((ResourceLocation)identifier, parentCategoryId, GsonHelper.getAsString((JsonObject)markdown.meta, (String)"title"), BookContentLoader.getIcon(markdown.meta), GsonHelper.getAsBoolean((JsonObject)markdown.meta, (String)"secret", (boolean)false), GsonHelper.getAsInt((JsonObject)markdown.meta, (String)"ordinal", (int)Integer.MAX_VALUE), markdown.content));
            });
        }
        for (Book book : BookLoader.allBooks()) {
            BookContentLoader.forResourceOfBook(entries, book, "entry", (identifier, resource) -> {
                MarkdownResource markdown = BookContentLoader.parseMarkdown(book, identifier, resource);
                if (markdown == null) {
                    return;
                }
                ArrayList<ResourceLocation> entryCategories = new ArrayList<ResourceLocation>();
                for (JsonElement categoryElement : GsonHelper.getAsJsonArray((JsonObject)markdown.meta, (String)"categories", (JsonArray)new JsonArray())) {
                    String categoryString = categoryElement.getAsString();
                    entryCategories.add(categoryString.indexOf(58) > 0 ? ResourceLocation.tryParse((String)categoryString) : ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)categoryString));
                }
                String legacyCategory = GsonHelper.getAsString((JsonObject)markdown.meta, (String)"category", null);
                if (legacyCategory != null) {
                    entryCategories.add(legacyCategory.indexOf(58) > 0 ? ResourceLocation.tryParse((String)legacyCategory) : ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)legacyCategory));
                }
                String title = GsonHelper.getAsString((JsonObject)markdown.meta, (String)"title");
                Function<Sizing, Component> icon = BookContentLoader.getIcon(markdown.meta);
                boolean secret = GsonHelper.getAsBoolean((JsonObject)markdown.meta, (String)"secret", (boolean)false);
                int ordinal = GsonHelper.getAsInt((JsonObject)markdown.meta, (String)"ordinal", (int)Integer.MAX_VALUE);
                ImmutableSet.Builder associatedItems = new ImmutableSet.Builder();
                for (Object itemElement : GsonHelper.getAsJsonArray((JsonObject)markdown.meta, (String)"associated_items", (JsonArray)new JsonArray())) {
                    associatedItems.addAll(BookContentLoader.itemsFromString(itemElement.getAsString()));
                }
                ImmutableSet.Builder requiredAdvancements = new ImmutableSet.Builder();
                for (Object advancementElement : GsonHelper.getAsJsonArray((JsonObject)markdown.meta, (String)"required_advancements", (JsonArray)new JsonArray())) {
                    if (!advancementElement.isJsonPrimitive()) continue;
                    ResourceLocation advancementId = ResourceLocation.tryParse((String)advancementElement.getAsString());
                    if (advancementId == null) {
                        Lavender.LOGGER.warn("Did not add advancement '{}' as requirement to entry '{}' as it is not a valid advancement identifier", (Object)advancementElement.getAsString(), identifier);
                        continue;
                    }
                    requiredAdvancements.add((Object)advancementId);
                }
                ImmutableSet.Builder additionalSearchTerms = new ImmutableSet.Builder();
                for (JsonElement termElement : GsonHelper.getAsJsonArray((JsonObject)markdown.meta, (String)"additional_search_terms", (JsonArray)new JsonArray())) {
                    if (!termElement.isJsonPrimitive()) continue;
                    String term = termElement.getAsString();
                    additionalSearchTerms.add((Object)term.toLowerCase(Locale.ROOT));
                }
                Entry entry = new Entry((ResourceLocation)identifier, (List<ResourceLocation>)entryCategories, title, icon, secret, ordinal, (ImmutableSet<ResourceLocation>)requiredAdvancements.build(), (ImmutableSet<ItemStack>)associatedItems.build(), (ImmutableSet<String>)additionalSearchTerms.build(), markdown.content);
                if (entry.id().getPath().equals("landing_page")) {
                    book.setLandingPage(entry);
                } else {
                    book.addEntry(entry);
                }
            });
        }
    }

    private static Map<String, Map<String, Resource>> findResources(ResourceManager manager, FileToIdConverter finder) {
        HashMap<String, Map<String, Resource>> resources = new HashMap<String, Map<String, Resource>>();
        finder.listMatchingResources(manager).forEach((identifier, resource) -> {
            ResourceLocation resourceId = finder.fileToId(identifier);
            resources.computeIfAbsent(resourceId.getNamespace(), s -> new HashMap()).put(resourceId.getPath(), resource);
        });
        return resources;
    }

    private static void forResourceOfBook(Map<String, Map<String, Resource>> resources, Book book, String resourceType, BiConsumer<ResourceLocation, Resource> action) {
        if (!resources.containsKey(book.id().getNamespace())) {
            return;
        }
        String targetBook = book.id().getPath();
        String activeLanguage = Minecraft.getInstance().getLanguageManager().getSelected();
        HashMap<ResourceLocation, Resource> discoveredResources = new HashMap<ResourceLocation, Resource>();
        resources.get(book.id().getNamespace()).forEach((path, resource) -> {
            String bookResourcePath = BookContentLoader.getBookResourcePath(path, targetBook, null);
            if (bookResourcePath == null) {
                return;
            }
            discoveredResources.put(ResourceLocation.fromNamespaceAndPath((String)book.id().getNamespace(), (String)bookResourcePath), (Resource)resource);
        });
        resources.get(book.id().getNamespace()).forEach((path, resource) -> {
            String bookResourcePath = BookContentLoader.getBookResourcePath(path, targetBook, activeLanguage);
            if (bookResourcePath == null) {
                return;
            }
            discoveredResources.put(ResourceLocation.fromNamespaceAndPath((String)book.id().getNamespace(), (String)bookResourcePath), (Resource)resource);
        });
        discoveredResources.forEach((resourceId, resource) -> {
            try {
                action.accept((ResourceLocation)resourceId, (Resource)resource);
            }
            catch (RuntimeException e) {
                Lavender.LOGGER.warn("Could not load {} '{}'", new Object[]{resourceType, resourceId, e});
            }
        });
    }

    @Nullable
    private static String getBookResourcePath(String resourcePath, String bookName, @Nullable String activeLanguage) {
        String book = null;
        String language = null;
        if (resourcePath.indexOf(47) != -1) {
            book = resourcePath.substring(0, resourcePath.indexOf(47));
            resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
        }
        if (resourcePath.indexOf(47) != -1) {
            language = resourcePath.substring(0, resourcePath.indexOf(47));
            if (Minecraft.getInstance().getLanguageManager().getLanguages().keySet().contains(language)) {
                resourcePath = resourcePath.substring(resourcePath.indexOf(47) + 1);
            } else {
                language = null;
            }
        }
        if (!bookName.equals(book) || !Objects.equals(activeLanguage, language)) {
            return null;
        }
        return resourcePath;
    }

    @Nullable
    private static MarkdownResource parseMarkdown(Book book, ResourceLocation resourceId, Resource resource) {
        try {
            String content = IOUtils.toString((InputStream)resource.open(), (Charset)StandardCharsets.UTF_8).strip();
            if (content.startsWith("```json")) {
                DataResult conditions;
                int frontmatterEnd = (content = content.substring("```json".length())).indexOf("```");
                if (frontmatterEnd == -1) {
                    throw new RuntimeException("Unterminated markdown meta");
                }
                JsonObject meta = (JsonObject)GSON.fromJson(content.substring(0, frontmatterEnd), JsonObject.class);
                content = content.substring(frontmatterEnd + 3).stripLeading();
                if (meta.has("fabric:load_conditions") && (conditions = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)meta.get("fabric:load_conditions"))).isSuccess() && !((ResourceCondition)conditions.getOrThrow()).test((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())) {
                    return null;
                }
                return new MarkdownResource(meta, book.expandMacros(resourceId, content.replaceAll("\\r\\n?", "\n")));
            }
            throw new RuntimeException("Missing markdown meta");
        }
        catch (Exception e) {
            Lavender.LOGGER.warn("Could not load markdown file {}", (Object)resourceId, (Object)e);
            return null;
        }
    }

    private static Function<Sizing, Component> getIcon(JsonObject meta) {
        if (meta.has("icon")) {
            ItemStack stack = BookContentLoader.itemStackFromString(GsonHelper.getAsString((JsonObject)meta, (String)"icon"));
            return sizing -> Components.item((ItemStack)stack).sizing(sizing);
        }
        if (meta.has("icon_sprite")) {
            ResourceLocation id = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)meta, (String)"icon_sprite"));
            if (id == null) {
                return null;
            }
            return sizing -> Components.sprite((TextureAtlasSprite)Minecraft.getInstance().getGuiSprites().getSprite(id)).sizing(sizing);
        }
        return sizing -> Containers.stack((Sizing)sizing, (Sizing)sizing);
    }

    private static Collection<ItemStack> itemsFromString(String itemsString) {
        if (!itemsString.startsWith("#")) {
            return List.of(BookContentLoader.itemStackFromString(itemsString));
        }
        ResourceLocation tagId = ResourceLocation.tryParse((String)itemsString.substring(1));
        if (tagId == null) {
            Lavender.LOGGER.warn("Could not parse tag ID '" + itemsString + "'");
            return List.of();
        }
        Optional entryList = BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId));
        if (entryList.isEmpty()) {
            Lavender.LOGGER.warn("Unknown item tag: '" + itemsString + "'");
            return List.of();
        }
        return ((HolderSet.Named)entryList.get()).stream().map(Holder::value).map(Item::getDefaultInstance).toList();
    }

    public static ItemStack itemStackFromString(String stackString) {
        try {
            ItemParser.ItemResult parsed = new ItemParser((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).parse(new StringReader(stackString));
            ItemStack stack = ((Item)parsed.item().value()).getDefaultInstance();
            if (parsed.components() != null) {
                stack.applyComponents(parsed.components());
            }
            return stack;
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid item stack: '" + stackString + "'", (Throwable)e);
        }
    }

    private record MarkdownResource(JsonObject meta, String content) {
    }
}

