/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.common.base.Preconditions;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.owo.ops.TextOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LavenderBookItem
extends Item {
    public static final DataComponentType<ResourceLocation> BOOK_ID = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)Lavender.id("book_id"), (Object)DataComponentType.builder().persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC).build());
    public static final LavenderBookItem DYNAMIC_BOOK = new LavenderBookItem(null, new Item.Properties().stacksTo(1));
    private static final Map<ResourceLocation, LavenderBookItem> BOOK_ITEMS = new HashMap<ResourceLocation, LavenderBookItem>();
    @Nullable
    private final ResourceLocation bookId;

    private LavenderBookItem(@Nullable ResourceLocation bookId, Item.Properties settings) {
        super(settings);
        this.bookId = bookId;
    }

    protected LavenderBookItem(Item.Properties settings, @NotNull ResourceLocation bookId) {
        super(settings);
        this.bookId = (ResourceLocation)Preconditions.checkNotNull((Object)bookId, (Object)"Book-specific book items must have a non-null book ID");
    }

    @NotNull
    protected ResourceLocation bookId() {
        return this.bookId;
    }

    public static LavenderBookItem registerForBook(@NotNull ResourceLocation bookId, Item.Properties settings) {
        return LavenderBookItem.registerForBook(bookId, bookId, settings);
    }

    public static LavenderBookItem registerForBook(@NotNull ResourceLocation bookId, @NotNull ResourceLocation itemId, Item.Properties settings) {
        return LavenderBookItem.registerForBook((LavenderBookItem)((Object)Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)itemId, (Object)((Object)new LavenderBookItem(bookId, settings)))));
    }

    public static LavenderBookItem registerForBook(LavenderBookItem item) {
        BOOK_ITEMS.put(item.bookId(), item);
        return item;
    }

    @Nullable
    public static ResourceLocation bookIdOf(ItemStack bookStack) {
        Item item = bookStack.getItem();
        if (!(item instanceof LavenderBookItem)) {
            return null;
        }
        LavenderBookItem book = (LavenderBookItem)item;
        return book.bookId != null ? book.bookId : (ResourceLocation)bookStack.get(BOOK_ID);
    }

    @Nullable
    public static Book bookOf(ItemStack bookStack) {
        ResourceLocation bookId = LavenderBookItem.bookIdOf(bookStack);
        if (bookId == null) {
            return null;
        }
        return BookLoader.get(bookId);
    }

    public static ItemStack itemOf(Book book) {
        LavenderBookItem bookItem = BOOK_ITEMS.get(book.id());
        if (bookItem != null) {
            return bookItem.getDefaultInstance();
        }
        return LavenderBookItem.createDynamic(book);
    }

    public Component getName(ItemStack stack) {
        if (this.bookId != null) {
            return super.getName(stack);
        }
        Book book = LavenderBookItem.bookOf(stack);
        if (book == null || book.dynamicBookName() == null) {
            return super.getName(stack);
        }
        return book.dynamicBookName();
    }

    public static ItemStack createDynamic(Book book) {
        ItemStack stack = DYNAMIC_BOOK.getDefaultInstance();
        stack.set(BOOK_ID, (Object)book.id());
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack playerStack = user.getItemInHand(hand);
        ResourceLocation bookId = LavenderBookItem.bookIdOf(playerStack);
        if (bookId == null) {
            return InteractionResultHolder.pass((Object)playerStack);
        }
        if (!world.isClientSide) {
            return InteractionResultHolder.success((Object)playerStack);
        }
        Book book = BookLoader.get(bookId);
        if (book == null) {
            user.sendSystemMessage((Component)Component.translatable((String)"text.lavender.unknown_book", (Object[])new Object[]{bookId}).withStyle(ChatFormatting.RED));
            return InteractionResultHolder.pass((Object)playerStack);
        }
        LavenderBookItem.openBookScreen(book);
        return InteractionResultHolder.success((Object)playerStack);
    }

    @Environment(value=EnvType.CLIENT)
    private static void openBookScreen(Book book) {
        Minecraft.getInstance().setScreen((Screen)new LavenderBookScreen(book));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        ResourceLocation bookId = LavenderBookItem.bookIdOf(stack);
        if (bookId == null) {
            tooltip.add((Component)TextOps.withFormatting((String)"\u26a0 \u00a7No associated book", (ChatFormatting[])new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.DARK_GRAY}));
        } else {
            Book book = BookLoader.get(bookId);
            if (book != null) {
                return;
            }
            tooltip.add((Component)TextOps.withFormatting((String)("\u26a0 \u00a7Unknown book \"" + String.valueOf(bookId) + "\""), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.DARK_GRAY}));
        }
    }
}

