/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.lavender.structure.StructureTemplate;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructureComponent
extends BaseComponent {
    private final StructureTemplate structure;
    private final int displayAngle;
    private float rotation = -45.0f;
    private long lastInteractionTime = 0L;
    private boolean placeable = true;
    private int visibleLayer = -1;

    public StructureComponent(StructureTemplate structure, int displayAngle) {
        this.structure = structure;
        this.displayAngle = displayAngle;
        this.cursorStyle(CursorStyle.HAND);
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        long diff = Util.getMillis() - this.lastInteractionTime;
        if (diff < 5000L) {
            return;
        }
        this.rotation += delta * Easing.SINE.apply(Math.min(1.0f, (float)(diff - 5000L) / 1500.0f));
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Minecraft client = Minecraft.getInstance();
        MultiBufferSource.BufferSource entityBuffers = client.renderBuffers().bufferSource();
        float scale = Math.min(this.width, this.height);
        scale /= (float)Math.max(this.structure.xSize, Math.max(this.structure.ySize, this.structure.zSize));
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        matrices.scale(scale /= 1.625f, -scale, scale);
        matrices.mulPose(Axis.XP.rotationDegrees((float)this.displayAngle));
        matrices.mulPose(Axis.YP.rotationDegrees(this.rotation));
        matrices.translate((float)this.structure.xSize / -2.0f, (float)this.structure.ySize / -2.0f, (float)this.structure.zSize / -2.0f);
        RenderSystem.runAsFancy(() -> {
            this.structure.forEachPredicate((blockPos, predicate) -> {
                if (this.visibleLayer != -1 && this.visibleLayer != blockPos.getY()) {
                    return;
                }
                matrices.pushPose();
                matrices.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
                client.getBlockRenderer().renderSingleBlock(predicate.preview(), matrices, (MultiBufferSource)entityBuffers, 240, OverlayTexture.NO_OVERLAY);
                matrices.popPose();
            });
            matrices.popPose();
            Lighting.setupForFlatItems();
            entityBuffers.endBatch();
            Lighting.setupFor3DItems();
        });
        if (this.placeable) {
            if (StructureOverlayRenderer.isShowingOverlay(this.structure.id)) {
                context.drawString(client.font, (Component)Component.translatable((String)"text.lavender.structure_component.active_overlay_hint"), this.x + this.width - 5 - client.font.width("\u2693"), this.y + this.height - 9 - 5, 0, false);
                this.tooltip((Component)Component.translatable((String)"text.lavender.structure_component.hide_hint"));
            } else {
                this.tooltip((Component)Component.translatable((String)"text.lavender.structure_component.place_hint"));
            }
        }
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        boolean result = super.onMouseDown(mouseX, mouseY, button);
        if (!this.placeable || button != 0 || !Screen.hasShiftDown()) {
            return result;
        }
        if (StructureOverlayRenderer.isShowingOverlay(this.structure.id)) {
            StructureOverlayRenderer.removeAllOverlays(this.structure.id);
        } else {
            StructureOverlayRenderer.addPendingOverlay(this.structure.id);
            StructureOverlayRenderer.restrictVisibleLayer(this.structure.id, this.visibleLayer);
            Minecraft.getInstance().setScreen(null);
        }
        return true;
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        boolean result = super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        if (button != 0) {
            return result;
        }
        this.rotation += (float)deltaX;
        this.lastInteractionTime = Util.getMillis();
        return true;
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public StructureComponent visibleLayer(int visibleLayer) {
        StructureOverlayRenderer.restrictVisibleLayer(this.structure.id, visibleLayer);
        this.visibleLayer = visibleLayer;
        return this;
    }

    public StructureComponent placeable(boolean placeable) {
        if (!placeable) {
            this.tooltip(null);
        }
        this.cursorStyle(placeable ? CursorStyle.HAND : CursorStyle.POINTER);
        this.placeable = placeable;
        return this;
    }

    public boolean placeable() {
        return this.placeable;
    }

    public static StructureComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"structure-id"});
        ResourceLocation structureId = ResourceLocation.tryParse((String)element.getAttribute("structure-id"));
        if (structureId == null) {
            throw new UIModelParsingException("Invalid structure id '" + element.getAttribute("structure-id") + "'");
        }
        StructureTemplate structure = LavenderStructures.get(structureId);
        if (structure == null) {
            throw new UIModelParsingException("Unknown structure '" + String.valueOf(structureId) + "'");
        }
        int displayAngle = 35;
        if (element.hasAttribute("display-angle")) {
            displayAngle = UIParsing.parseSignedInt((Node)element.getAttributeNode("display-angle"));
        }
        return new StructureComponent(structure, displayAngle);
    }
}

