/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.LavenderCommands;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookContentLoader;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.ClientNewEntriesUnlockedCallback;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.client.BlitAlphaProgram;
import io.wispforest.lavender.client.BlitCutoutProgram;
import io.wispforest.lavender.client.BookBakedModel;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavender.client.NewEntriesToast;
import io.wispforest.lavender.client.OffhandBookRenderer;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.md.ItemListComponent;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.hud.Hud;
import io.wispforest.owo.ui.parsing.UIParsing;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LavenderClient
implements ClientModInitializer {
    public static final BlitCutoutProgram BLIT_CUTOUT_PROGRAM = new BlitCutoutProgram();
    public static final BlitAlphaProgram BLIT_ALPHA_PROGRAM = new BlitAlphaProgram();
    private static final Int2ObjectMap<Size> TEXTURE_SIZES = new Int2ObjectOpenHashMap();
    private static final ResourceLocation ENTRY_HUD_ID = Lavender.id("entry_hud");
    private static UUID currentWorldId = null;

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register(LavenderCommands.Client::register);
        ModelLoadingPlugin.register(pluginContext -> pluginContext.resolveModel().register(context -> {
            if (!context.id().equals((Object)Lavender.id("item/dynamic_book"))) {
                return null;
            }
            return new BookBakedModel.Unbaked();
        }));
        StructureOverlayRenderer.initialize();
        OffhandBookRenderer.initialize();
        LavenderStructures.initialize();
        BookLoader.initialize();
        BookContentLoader.initialize();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            BookLoader.reload(Minecraft.getInstance().getResourceManager());
            BookContentLoader.reloadContents(Minecraft.getInstance().getResourceManager());
        });
        Hud.add((ResourceLocation)ENTRY_HUD_ID, () -> Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(5).positioning(Positioning.across((int)50, (int)52)));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            Component patt0$temp;
            if (client.level == null || !((patt0$temp = Hud.getComponent((ResourceLocation)ENTRY_HUD_ID)) instanceof FlowLayout)) {
                return;
            }
            FlowLayout hudComponent = (FlowLayout)patt0$temp;
            hudComponent.configure(container -> {
                container.clearChildren();
                Book book = LavenderBookItem.bookOf(client.player.getMainHandItem());
                if (book == null) {
                    book = LavenderBookItem.bookOf(client.player.getOffhandItem());
                }
                if (book == null) {
                    return;
                }
                HitResult patt0$temp = client.hitResult;
                if (!(patt0$temp instanceof BlockHitResult)) {
                    return;
                }
                BlockHitResult hitResult = (BlockHitResult)patt0$temp;
                Item item = client.level.getBlockState(hitResult.getBlockPos()).getBlock().asItem();
                if (item == Items.AIR) {
                    return;
                }
                Entry associatedEntry = book.entryByAssociatedItem(item.getDefaultInstance());
                if (associatedEntry == null || !associatedEntry.canPlayerView(client.player)) {
                    return;
                }
                container.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(associatedEntry.iconFactory().apply(Sizing.fixed((int)16)).margins(Insets.of((int)0, (int)1, (int)0, (int)1))).child(Components.item((ItemStack)LavenderBookItem.itemOf(book)).sizing(Sizing.fixed((int)8)).positioning(Positioning.absolute((int)9, (int)9)).zIndex(50)));
                container.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)associatedEntry.title())).shadow(true)).child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)(client.player.isShiftKeyDown() ? "text.lavender.entry_hud.click_to_view" : "text.lavender.entry_hud.sneak_to_view")))));
            });
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            ItemStack stack = player.getItemInHand(hand);
            if (!player.isShiftKeyDown()) {
                return InteractionResult.PASS;
            }
            Book book = LavenderBookItem.bookOf(stack);
            if (book == null) {
                return InteractionResult.PASS;
            }
            Item item = world.getBlockState(hitResult.getBlockPos()).getBlock().asItem();
            if (item == Items.AIR) {
                return InteractionResult.PASS;
            }
            Entry associatedEntry = book.entryByAssociatedItem(item.getDefaultInstance());
            if (associatedEntry == null || !associatedEntry.canPlayerView((LocalPlayer)player)) {
                return InteractionResult.PASS;
            }
            LavenderBookScreen.pushEntry(book, associatedEntry);
            Minecraft.getInstance().setScreen((Screen)new LavenderBookScreen(book));
            player.swing(hand);
            return InteractionResult.FAIL;
        });
        ClientNewEntriesUnlockedCallback.EVENT.register((client, book, newEntryCount) -> {
            if (book.newEntriesToast() != null) {
                client.getToasts().addToast((Toast)new NewEntriesToast(book.newEntriesToast()));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(Lavender.WorldUUIDPayload.ID, (payload, context) -> {
            currentWorldId = payload.worldUuid();
        });
        UIParsing.registerFactory((ResourceLocation)Lavender.id("ingredient"), element -> {
            Lavender.LOGGER.warn("Deprecated <ingredient> element used, migrate to <item-list> instead");
            return new ItemListComponent();
        });
        UIParsing.registerFactory((ResourceLocation)Lavender.id("item-list"), element -> new ItemListComponent());
    }

    public static UUID currentWorldId() {
        return currentWorldId;
    }

    public static void registerTextureSize(int textureId, int width, int height) {
        TEXTURE_SIZES.put(textureId, (Object)Size.of((int)width, (int)height));
    }

    @Nullable
    public static Size getTextureSize(ResourceLocation texture) {
        return (Size)TEXTURE_SIZES.get(Minecraft.getInstance().getTextureManager().getTexture(texture).getId());
    }
}

