/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.features;

import io.wispforest.lavender.Lavender;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.network.chat.Component;

public class OwoUIModelFeature
implements MarkdownFeature {
    public String name() {
        return "owo_ui_models";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("```xml owo-ui")) {
                return false;
            }
            String content = nibbler.consumeUntil('`');
            if (content == null || !nibbler.tryConsume("``")) {
                return false;
            }
            tokens.add(new UIModelToken(content, content));
            return true;
        }, '`');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, stackToken, tokens) -> new UIModelNode(stackToken.xmlContent), (token, tokens) -> {
            UIModelToken model;
            return token instanceof UIModelToken ? (model = (UIModelToken)((Object)token)) : null;
        });
    }

    private static class UIModelToken
    extends Lexer.Token {
        public final String xmlContent;

        public UIModelToken(String content, String xmlContent) {
            super(content);
            this.xmlContent = xmlContent;
        }
    }

    private static class UIModelNode
    extends Parser.Node {
        private static final String MODEL_TEMPLATE = "<owo-ui>\n    <templates>\n        <template name=\"__model-feature-generated__\">\n            {{template-content}}\n        </template>\n    </templates>\n</owo-ui>\n";
        private final String modelString;

        public UIModelNode(String xmlContent) {
            this.modelString = MODEL_TEMPLATE.replaceFirst("\\{\\{template-content}}", xmlContent);
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            try {
                UIModel model = UIModel.load((InputStream)new ByteArrayInputStream(this.modelString.getBytes(StandardCharsets.UTF_8)));
                ((OwoUICompiler)compiler).visitComponent(model.expandTemplate(io.wispforest.owo.ui.core.Component.class, "__model-feature-generated__", Map.of()));
            }
            catch (Exception e) {
                Lavender.LOGGER.warn("Failed to build owo-ui model markdown element", (Throwable)e);
                ((OwoUICompiler)compiler).visitComponent((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.label((Component)Component.literal((String)e.getMessage())).horizontalSizing(Sizing.fill((int)100))).padding(Insets.of((int)10)).surface(Surface.flat((int)0x77A00000).and(Surface.outline((int)0x77FF0000))));
            }
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

