/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.features;

import io.wispforest.lavender.md.ItemListComponent;
import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavender.pond.SmithingRecipeAccessor;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeFeature
implements MarkdownFeature {
    private final BookCompiler.ComponentSource bookComponentSource;
    private final Map<RecipeType<?>, RecipePreviewBuilder<?>> previewBuilders;
    public static final RecipePreviewBuilder<CraftingRecipe> CRAFTING_PREVIEW_BUILDER = new RecipePreviewBuilder<CraftingRecipe>(){

        @Override
        @NotNull
        public Component buildRecipePreview(BookCompiler.ComponentSource componentSource, RecipeHolder<CraftingRecipe> recipeEntry) {
            ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "crafting-recipe");
            this.populateIngredientsGrid(recipeEntry, (List<Ingredient>)((CraftingRecipe)recipeEntry.value()).getIngredients(), (ParentComponent)recipeComponent.childById(ParentComponent.class, "input-grid"), 3, 3);
            ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(((CraftingRecipe)recipeEntry.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
            return recipeComponent;
        }
    };
    public static final RecipePreviewBuilder<AbstractCookingRecipe> SMELTING_PREVIEW_BUILDER = (componentSource, recipeEntry) -> {
        AbstractCookingRecipe recipe = (AbstractCookingRecipe)recipeEntry.value();
        ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "smelting-recipe");
        ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input")).ingredient((Ingredient)recipe.getIngredients().get(0));
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        ItemStack workstation = ItemStack.EMPTY;
        if (recipe instanceof SmeltingRecipe) {
            workstation = Items.FURNACE.getDefaultInstance();
        }
        if (recipe instanceof BlastingRecipe) {
            workstation = Items.BLAST_FURNACE.getDefaultInstance();
        }
        if (recipe instanceof SmokingRecipe) {
            workstation = Items.SMOKER.getDefaultInstance();
        }
        if (recipe instanceof CampfireCookingRecipe) {
            workstation = Items.CAMPFIRE.getDefaultInstance();
        }
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "workstation")).stack(workstation);
        return recipeComponent;
    };
    public static final RecipePreviewBuilder<SmithingRecipe> SMITHING_PREVIEW_BUILDER = (componentSource, recipeEntry) -> {
        SmithingRecipe recipe = (SmithingRecipe)recipeEntry.value();
        ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "smithing-recipe");
        if (recipe instanceof SmithingRecipeAccessor) {
            SmithingRecipeAccessor accessor = (SmithingRecipeAccessor)recipe;
            ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input-1")).ingredient(accessor.lavender$getTemplate());
            ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input-2")).ingredient(accessor.lavender$getBase());
            ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input-3")).ingredient(accessor.lavender$getAddition());
        }
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        return recipeComponent;
    };
    public static final RecipePreviewBuilder<StonecutterRecipe> STONECUTTING_PREVIEW_BUILDER = (componentSource, recipeEntry) -> {
        StonecutterRecipe recipe = (StonecutterRecipe)recipeEntry.value();
        ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "stonecutting-recipe");
        ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input")).ingredient((Ingredient)recipe.getIngredients().get(0));
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        return recipeComponent;
    };
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<CraftingRecipe> CRAFTING_HANDLER = CRAFTING_PREVIEW_BUILDER;
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<AbstractCookingRecipe> SMELTING_HANDLER = SMELTING_PREVIEW_BUILDER;
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<SmithingRecipe> SMITHING_HANDLER = SMITHING_PREVIEW_BUILDER;
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<StonecutterRecipe> STONECUTTING_HANDLER = STONECUTTING_PREVIEW_BUILDER;

    public RecipeFeature(BookCompiler.ComponentSource bookComponentSource, @Nullable Map<RecipeType<?>, RecipePreviewBuilder<?>> previewBuilders) {
        this.bookComponentSource = bookComponentSource;
        this.previewBuilders = new HashMap(previewBuilders != null ? previewBuilders : Map.of());
        this.previewBuilders.putIfAbsent(RecipeType.CRAFTING, CRAFTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(RecipeType.SMELTING, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(RecipeType.BLASTING, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(RecipeType.SMOKING, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(RecipeType.CAMPFIRE_COOKING, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(RecipeType.SMITHING, SMITHING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(RecipeType.STONECUTTING, STONECUTTING_PREVIEW_BUILDER);
    }

    public String name() {
        return "recipes";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<recipe;")) {
                return false;
            }
            String recipeIdString = nibbler.consumeUntil('>');
            if (recipeIdString == null) {
                return false;
            }
            ResourceLocation recipeId = ResourceLocation.tryParse((String)recipeIdString);
            if (recipeId == null) {
                return false;
            }
            Optional recipe = Minecraft.getInstance().level.getRecipeManager().byKey(recipeId);
            if (recipe.isEmpty()) {
                return false;
            }
            tokens.add(new RecipeToken(recipeIdString, (RecipeHolder)recipe.get()));
            return true;
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, recipeToken, tokens) -> new RecipeNode(recipeToken.recipe), (token, tokens) -> {
            RecipeToken recipe;
            return token instanceof RecipeToken ? (recipe = (RecipeToken)((Object)token)) : null;
        });
    }

    @FunctionalInterface
    public static interface RecipePreviewBuilder<R extends Recipe<?>> {
        @NotNull
        public Component buildRecipePreview(BookCompiler.ComponentSource var1, RecipeHolder<R> var2);

        default public void populateIngredients(RecipeHolder<R> recipe, List<Ingredient> ingredients, ParentComponent componentContainer) {
            for (int i = 0; i < ingredients.size(); ++i) {
                Object e = componentContainer.children().get(i);
                if (!(e instanceof ItemListComponent)) continue;
                ItemListComponent ingredient = (ItemListComponent)((Object)e);
                ingredient.ingredient(ingredients.get(i));
            }
        }

        default public void populateIngredientsGrid(RecipeHolder<R> recipe, List<Ingredient> ingredients, ParentComponent componentContainer, int gridWidth, int gridHeight) {
            ((PlaceRecipe)(input, slot, amount, gridX, gridY) -> {
                Object patt0$temp = componentContainer.children().get(slot);
                if (!(patt0$temp instanceof ItemListComponent)) {
                    return;
                }
                ItemListComponent ingredient = (ItemListComponent)((Object)((Object)patt0$temp));
                ingredient.ingredient((Ingredient)input);
            }).placeRecipe(gridWidth, gridHeight, 9, recipe, ingredients.iterator(), 0);
        }
    }

    private static class RecipeToken
    extends Lexer.Token {
        public final RecipeHolder<Recipe<?>> recipe;

        public RecipeToken(String content, RecipeHolder<Recipe<?>> recipe) {
            super(content);
            this.recipe = recipe;
        }
    }

    private class RecipeNode
    extends Parser.Node {
        private final RecipeHolder<Recipe<?>> recipe;

        public RecipeNode(RecipeHolder<Recipe<?>> recipe) {
            this.recipe = recipe;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            RecipePreviewBuilder<?> previewBuilder = RecipeFeature.this.previewBuilders.get(this.recipe.value().getType());
            if (previewBuilder != null) {
                ((OwoUICompiler)compiler).visitComponent(previewBuilder.buildRecipePreview(RecipeFeature.this.bookComponentSource, this.recipe));
            } else {
                ((OwoUICompiler)compiler).visitComponent((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)("No preview builder registered for recipe type '" + String.valueOf(BuiltInRegistries.RECIPE_TYPE.getKey((Object)this.recipe.value().getType())) + "'"))).horizontalSizing(Sizing.fill((int)100))).padding(Insets.of((int)10)).surface(Surface.flat((int)0x77A00000).and(Surface.outline((int)0x77FF0000))));
            }
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }

    @Deprecated(forRemoval=true)
    public static interface RecipeHandler<R extends Recipe<?>>
    extends RecipePreviewBuilder<R> {
    }
}

