/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.mixin;

import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavender.client.OffhandBookRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public Screen screen;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onFrameStart(boolean tick, CallbackInfo ci) {
        if (this.player == null) {
            return;
        }
        Book bookToRender = null;
        ItemStack offhandStack = this.player.getOffhandItem();
        if (offhandStack.getItem() instanceof LavenderBookItem && LavenderBookItem.bookOf(offhandStack) != null && !(this.screen instanceof LavenderBookScreen)) {
            bookToRender = LavenderBookItem.bookOf(offhandStack);
        }
        OffhandBookRenderer.beginFrame(bookToRender);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onFrameEnd(boolean tick, CallbackInfo ci) {
        if (this.player == null) {
            return;
        }
        OffhandBookRenderer.endFrame();
    }
}

