/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.wispforest.lavender.structure.BlockStatePredicate;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class StructureTemplate {
    private final BlockStatePredicate[][][] predicates;
    private final EnumMap<BlockStatePredicate.MatchCategory, MutableInt> predicateCountByType;
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final Vec3i anchor;
    public final ResourceLocation id;

    public StructureTemplate(ResourceLocation id, BlockStatePredicate[][][] predicates, int xSize, int ySize, int zSize, @Nullable Vec3i anchor) {
        this.id = id;
        this.predicates = predicates;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.anchor = anchor != null ? anchor : new Vec3i(this.xSize / 2, 0, this.ySize / 2);
        this.predicateCountByType = new EnumMap(BlockStatePredicate.MatchCategory.class);
        for (BlockStatePredicate.MatchCategory type : BlockStatePredicate.MatchCategory.values()) {
            this.forEachPredicate((blockPos, predicate) -> {
                if (!predicate.isOf(type)) {
                    return;
                }
                this.predicateCountByType.computeIfAbsent(type, $ -> new MutableInt()).increment();
            });
        }
    }

    public int predicatesOfType(BlockStatePredicate.MatchCategory type) {
        return this.predicateCountByType.get((Object)type).intValue();
    }

    public Vec3i anchor() {
        return this.anchor;
    }

    public void forEachPredicate(BiConsumer<BlockPos, BlockStatePredicate> action) {
        this.forEachPredicate(action, Rotation.NONE);
    }

    public void forEachPredicate(BiConsumer<BlockPos, BlockStatePredicate> action, Rotation rotation) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.predicates.length; ++x) {
            for (int y = 0; y < this.predicates[x].length; ++y) {
                for (int z = 0; z < this.predicates[x][y].length; ++z) {
                    switch (rotation) {
                        case CLOCKWISE_90: {
                            mutable.set(this.zSize - z - 1, y, x);
                            break;
                        }
                        case COUNTERCLOCKWISE_90: {
                            mutable.set(z, y, this.xSize - x - 1);
                            break;
                        }
                        case CLOCKWISE_180: {
                            mutable.set(this.xSize - x - 1, y, this.zSize - z - 1);
                            break;
                        }
                        default: {
                            mutable.set(x, y, z);
                        }
                    }
                    action.accept((BlockPos)mutable, this.predicates[x][y][z]);
                }
            }
        }
    }

    public boolean validate(Level world, BlockPos anchor) {
        return this.validate(world, anchor, Rotation.NONE);
    }

    public boolean validate(Level world, BlockPos anchor, Rotation rotation) {
        return this.countValidStates(world, anchor, rotation) == this.predicatesOfType(BlockStatePredicate.MatchCategory.NON_NULL);
    }

    public int countValidStates(Level world, BlockPos anchor) {
        return this.countValidStates(world, anchor, Rotation.NONE, BlockStatePredicate.MatchCategory.NON_NULL);
    }

    public int countValidStates(Level world, BlockPos anchor, Rotation rotation) {
        return this.countValidStates(world, anchor, rotation, BlockStatePredicate.MatchCategory.NON_NULL);
    }

    public int countValidStates(Level world, BlockPos anchor, Rotation rotation, BlockStatePredicate.MatchCategory predicateFilter) {
        MutableInt validStates = new MutableInt();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        this.forEachPredicate((pos, predicate) -> {
            if (!predicate.isOf(predicateFilter)) {
                return;
            }
            if (predicate.matches(world.getBlockState((BlockPos)mutable.set((Vec3i)pos).move((Vec3i)anchor)).rotate(StructureTemplate.inverse(rotation)))) {
                validStates.increment();
            }
        }, rotation);
        return validStates.intValue();
    }

    public BlockAndTintGetter asBlockRenderView() {
        final ClientLevel world = Minecraft.getInstance().level;
        return new BlockAndTintGetter(){

            public float getShade(Direction direction, boolean shaded) {
                return 1.0f;
            }

            public LevelLightEngine getLightEngine() {
                return world.getLightEngine();
            }

            public int getBlockTint(BlockPos pos, ColorResolver colorResolver) {
                return colorResolver.getColor((Biome)world.getBiome(pos).value(), (double)pos.getX(), (double)pos.getZ());
            }

            @Nullable
            public BlockEntity getBlockEntity(BlockPos pos) {
                return null;
            }

            public BlockState getBlockState(BlockPos pos) {
                if (pos.getX() < 0 || pos.getX() >= StructureTemplate.this.xSize || pos.getY() < 0 || pos.getY() >= StructureTemplate.this.ySize || pos.getZ() < 0 || pos.getZ() >= StructureTemplate.this.zSize) {
                    return Blocks.AIR.defaultBlockState();
                }
                return StructureTemplate.this.predicates[pos.getX()][pos.getY()][pos.getZ()].preview();
            }

            public FluidState getFluidState(BlockPos pos) {
                return Fluids.EMPTY.defaultFluidState();
            }

            public int getHeight() {
                return world.getHeight();
            }

            public int getMinBuildHeight() {
                return world.getMinBuildHeight();
            }
        };
    }

    public static Rotation inverse(Rotation rotation) {
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> Rotation.NONE;
            case Rotation.CLOCKWISE_90 -> Rotation.COUNTERCLOCKWISE_90;
            case Rotation.COUNTERCLOCKWISE_90 -> Rotation.CLOCKWISE_90;
            case Rotation.CLOCKWISE_180 -> Rotation.CLOCKWISE_180;
        };
    }

    public static StructureTemplate parse(ResourceLocation resourceId, JsonObject json) {
        JsonObject keyObject = GsonHelper.getAsJsonObject((JsonObject)json, (String)"keys");
        Char2ObjectOpenHashMap keys = new Char2ObjectOpenHashMap();
        Vec3i anchor = null;
        for (Map.Entry entry : keyObject.entrySet()) {
            char key;
            if (((String)entry.getKey()).length() == 1) {
                key = ((String)entry.getKey()).charAt(0);
                if (key == '#') {
                    throw new JsonParseException("Key '#' is reserved for 'anchor' declarations");
                }
            } else {
                if (!((String)entry.getKey()).equals("anchor")) continue;
                key = '#';
            }
            try {
                Iterator predicate;
                Either result = BlockStateParser.parseForTesting((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)((JsonElement)entry.getValue()).getAsString(), (boolean)false);
                if (result.left().isPresent()) {
                    predicate = (BlockStateParser.BlockResult)result.left().get();
                    keys.put(key, (Object)new BlockStatePredicate((BlockStateParser.BlockResult)predicate){
                        final /* synthetic */ BlockStateParser.BlockResult val$predicate;
                        {
                            this.val$predicate = blockResult;
                        }

                        @Override
                        public BlockState preview() {
                            return this.val$predicate.blockState();
                        }

                        @Override
                        public BlockStatePredicate.Result test(BlockState state) {
                            if (state.getBlock() != this.val$predicate.blockState().getBlock()) {
                                return BlockStatePredicate.Result.NO_MATCH;
                            }
                            for (Map.Entry propAndValue : this.val$predicate.properties().entrySet()) {
                                if (state.getValue((Property)propAndValue.getKey()).equals(propAndValue.getValue())) continue;
                                return BlockStatePredicate.Result.BLOCK_MATCH;
                            }
                            return BlockStatePredicate.Result.STATE_MATCH;
                        }
                    });
                    continue;
                }
                predicate = (BlockStateParser.TagResult)result.right().get();
                final ArrayList previewStates = new ArrayList();
                predicate.tag().forEach(arg_0 -> StructureTemplate.lambda$parse$3((BlockStateParser.TagResult)predicate, previewStates, arg_0));
                keys.put(key, (Object)new BlockStatePredicate(){
                    final /* synthetic */ BlockStateParser.TagResult val$predicate;
                    {
                        this.val$predicate = tagResult;
                    }

                    @Override
                    public BlockState preview() {
                        if (previewStates.isEmpty()) {
                            return Blocks.AIR.defaultBlockState();
                        }
                        return (BlockState)previewStates.get((int)(System.currentTimeMillis() / 1000L % (long)previewStates.size()));
                    }

                    @Override
                    public BlockStatePredicate.Result test(BlockState state) {
                        if (!state.is(this.val$predicate.tag())) {
                            return BlockStatePredicate.Result.NO_MATCH;
                        }
                        for (Map.Entry propAndValue : this.val$predicate.vagueProperties().entrySet()) {
                            Property prop = state.getBlock().getStateDefinition().getProperty((String)propAndValue.getKey());
                            if (prop == null) {
                                return BlockStatePredicate.Result.BLOCK_MATCH;
                            }
                            Optional expected = prop.getValue((String)propAndValue.getValue());
                            if (expected.isEmpty()) {
                                return BlockStatePredicate.Result.BLOCK_MATCH;
                            }
                            if (state.getValue(prop).equals(expected.get())) continue;
                            return BlockStatePredicate.Result.BLOCK_MATCH;
                        }
                        return BlockStatePredicate.Result.STATE_MATCH;
                    }
                });
            }
            catch (CommandSyntaxException e) {
                throw new JsonParseException("Failed to parse block state predicate", (Throwable)e);
            }
        }
        JsonArray layersArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"layers");
        int xSize = 0;
        int ySize = layersArray.size();
        int zSize = 0;
        for (JsonElement element : layersArray) {
            if (!(element instanceof JsonArray)) {
                throw new JsonParseException("Every element in the 'layers' array must itself be an array");
            }
            JsonArray layer = (JsonArray)element;
            if (zSize == 0) {
                zSize = layer.size();
            } else if (zSize != layer.size()) {
                throw new JsonParseException("Every layer must have the same amount of rows");
            }
            for (JsonElement rowElement : layer) {
                if (!rowElement.isJsonPrimitive()) {
                    throw new JsonParseException("Every element in a row must be a primitive");
                }
                if (xSize == 0) {
                    xSize = rowElement.getAsString().length();
                    continue;
                }
                if (xSize == rowElement.getAsString().length()) continue;
                throw new JsonParseException("Every row must have the same length");
            }
        }
        BlockStatePredicate[][][] result = new BlockStatePredicate[xSize][][];
        for (int x = 0; x < xSize; ++x) {
            result[x] = new BlockStatePredicate[ySize][];
            for (int y = 0; y < ySize; ++y) {
                result[x][y] = new BlockStatePredicate[zSize];
            }
        }
        for (int y = 0; y < layersArray.size(); ++y) {
            JsonArray layer = (JsonArray)layersArray.get(y);
            for (int z = 0; z < layer.size(); ++z) {
                String row = layer.get(z).getAsString();
                for (int x = 0; x < row.length(); ++x) {
                    BlockStatePredicate predicate;
                    char key = row.charAt(x);
                    if (keys.containsKey(key)) {
                        predicate = (BlockStatePredicate)keys.get(key);
                        if (key == '#') {
                            if (anchor != null) {
                                throw new JsonParseException("Anchor key '#' cannot be used twice within the same structure");
                            }
                            anchor = new Vec3i(x, y, z);
                        }
                    } else if (key == ' ') {
                        predicate = BlockStatePredicate.NULL_PREDICATE;
                    } else if (key == '_') {
                        predicate = BlockStatePredicate.AIR_PREDICATE;
                    } else {
                        throw new JsonParseException("Unknown key '" + key + "'");
                    }
                    result[x][y][z] = predicate;
                }
            }
        }
        return new StructureTemplate(resourceId, result, xSize, ySize, zSize, anchor);
    }

    private static /* synthetic */ void lambda$parse$3(BlockStateParser.TagResult predicate, ArrayList previewStates, Holder registryEntry) {
        Block block = (Block)registryEntry.value();
        BlockState state = block.defaultBlockState();
        for (Map.Entry propAndValue : predicate.vagueProperties().entrySet()) {
            Property prop = block.getStateDefinition().getProperty((String)propAndValue.getKey());
            if (prop == null) {
                return;
            }
            Optional value = prop.getValue((String)propAndValue.getValue());
            if (value.isEmpty()) {
                return;
            }
            state = (BlockState)state.setValue(prop, (Comparable)value.get());
        }
        previewStates.add(state);
    }
}

