/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;

public final class PropertyKey<T, V extends GearPropertyValue<T>> {
    private static final Map<Pair<GearProperty<?, ? extends GearPropertyValue<?>>, GearType>, PropertyKey<?, ?>> CACHE = new ConcurrentHashMap();
    public static final Codec<PropertyKey<?, ? extends GearPropertyValue<?>>> CODEC = Codec.STRING.comapFlatMap(PropertyKey::fromString, PropertyKey::key);
    public static final StreamCodec<RegistryFriendlyByteBuf, PropertyKey<?, ?>> STREAM_CODEC = StreamCodec.of(PropertyKey::encode, PropertyKey::decode);
    private final String key;
    private final GearProperty<T, V> property;
    private final GearType gearType;

    private PropertyKey(GearProperty<T, V> property, GearType gearType) {
        this.property = property;
        this.gearType = gearType;
        this.key = SilentGear.shortenId(SgRegistries.GEAR_PROPERTY.getKey(this.property)) + this.makeKeySuffix();
    }

    public static <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> PropertyKey<T, V> of(Supplier<P> property, Supplier<GearType> gearType) {
        return PropertyKey.of((GearProperty)property.get(), gearType.get());
    }

    public static <T, V extends GearPropertyValue<T>> PropertyKey<T, V> of(GearProperty<T, V> property, GearType gearType) {
        return CACHE.computeIfAbsent(Pair.of(property, (Object)gearType), pair -> new PropertyKey((GearProperty)pair.getFirst(), (GearType)pair.getSecond()));
    }

    public String key() {
        return this.key;
    }

    public GearProperty<T, V> property() {
        return this.property;
    }

    public GearType gearType() {
        return this.gearType;
    }

    @Nullable
    public PropertyKey<?, ?> getParent() {
        Supplier<GearType> parent = this.gearType.parent();
        if (parent != null) {
            return PropertyKey.of(this.property, parent.get());
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PropertyKey that = (PropertyKey)obj;
        return Objects.equals(this.property, that.property) && Objects.equals(this.gearType, that.gearType);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.gearType);
    }

    public String toString() {
        return "PropertyKey[property=" + String.valueOf(this.property) + ", gearType=" + String.valueOf(this.gearType) + "]";
    }

    private static DataResult<PropertyKey<?, ?>> fromString(String s) {
        GearType gearType;
        String[] split = s.split("/");
        if (split.length > 2) {
            return DataResult.error(() -> "Invalid key: " + s);
        }
        GearProperty property = (GearProperty)SgRegistries.GEAR_PROPERTY.get(SilentGear.getIdWithDefaultNamespace(split[0]));
        if (property == null) {
            return DataResult.error(() -> "Unknown gear property: \"" + split[0] + "\" in key " + s);
        }
        if (split.length > 1) {
            gearType = (GearType)SgRegistries.GEAR_TYPE.get(SilentGear.getIdWithDefaultNamespace(split[1]));
            if (gearType == null || gearType == GearTypes.NONE.get()) {
                return DataResult.error(() -> "Unknown gear type: \"" + split[1] + "\" in key " + s);
            }
        } else {
            gearType = (GearType)GearTypes.ALL.get();
        }
        return DataResult.success(new PropertyKey(property, gearType));
    }

    private static void encode(RegistryFriendlyByteBuf buf, PropertyKey<?, ?> key) {
        ByteBufCodecs.registry(SgRegistries.GEAR_PROPERTY_KEY).encode((Object)buf, key.property);
        ByteBufCodecs.registry(SgRegistries.GEAR_TYPE_KEY).encode((Object)buf, (Object)key.gearType);
    }

    private static PropertyKey<?, ?> decode(RegistryFriendlyByteBuf buf) {
        GearProperty property = (GearProperty)ByteBufCodecs.registry(SgRegistries.GEAR_PROPERTY_KEY).decode((Object)buf);
        GearType gearType = (GearType)ByteBufCodecs.registry(SgRegistries.GEAR_TYPE_KEY).decode((Object)buf);
        return new PropertyKey(property, gearType);
    }

    private String makeKeySuffix() {
        if (this.gearType != GearTypes.ALL.get()) {
            return "/" + SilentGear.shortenId(SgRegistries.GEAR_TYPE.getKey((Object)this.gearType));
        }
        return "";
    }
}

