/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.alloymaker.screen.AlloyForgeScreen;
import net.silentchaos512.gear.block.alloymaker.screen.RecrystallizerScreen;
import net.silentchaos512.gear.block.alloymaker.screen.RefabricatorScreen;
import net.silentchaos512.gear.block.alloymaker.screen.SuperMixerScreen;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.compat.jei.AlloyMakingRecipeCategory;
import net.silentchaos512.gear.compat.jei.GearCraftingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.MaterialGraderRecipeCategory;
import net.silentchaos512.gear.compat.jei.SalvagingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.ToolActionRecipeCategory;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.ToolActionRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.FabricAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.GemAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.MetalAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.SuperAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class SGearJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SilentGear.getId("plugin/main");
    public static final RecipeType<AlloyRecipe> ALLOY_MAKING_FABRIC_TYPE = RecipeType.create((String)"silentgear", (String)"alloy_making/fabric", AlloyRecipe.class);
    public static final RecipeType<AlloyRecipe> ALLOY_MAKING_GEM_TYPE = RecipeType.create((String)"silentgear", (String)"alloy_making/gem", AlloyRecipe.class);
    public static final RecipeType<AlloyRecipe> ALLOY_MAKING_METAL_TYPE = RecipeType.create((String)"silentgear", (String)"alloy_making/metal", AlloyRecipe.class);
    public static final RecipeType<AlloyRecipe> ALLOY_MAKING_SUPER_TYPE = RecipeType.create((String)"silentgear", (String)"alloy_making/super", AlloyRecipe.class);
    static final RecipeType<CraftingRecipe> GEAR_CRAFTING_TYPE = RecipeType.create((String)"silentgear", (String)"gear_crafting", CraftingRecipe.class);
    static final RecipeType<MaterialGraderRecipeCategory.GraderRecipe> GRADING_TYPE = RecipeType.create((String)"silentgear", (String)"grading", MaterialGraderRecipeCategory.GraderRecipe.class);
    static final RecipeType<SalvagingRecipe> SALVAGING_TYPE = RecipeType.create((String)"silentgear", (String)"salvaging", SalvagingRecipe.class);
    static final RecipeType<ToolActionRecipe> TOOL_ACTION_TYPE = RecipeType.create((String)"silentgear", (String)"tool_action", ToolActionRecipe.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new GearCraftingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.FABRIC_ALLOY_MAKER_INFO, "fabric", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.GEM_ALLOY_MAKER_INFO, "gem", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.METAL_ALLOY_MAKER_INFO, "metal", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.SUPER_MIXER_INFO, "super", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new MaterialGraderRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new ToolActionRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        for (RepairKitItem repairKitItem : SgItems.getItems(RepairKitItem.class)) {
            String itemName = NameUtils.fromItem((ItemLike)repairKitItem).getPath();
            reg.addRecipes(RecipeTypes.CRAFTING, Collections.singletonList(new RecipeHolder(SilentGear.getId(itemName), (Recipe)new ShapelessRecipe("", CraftingBookCategory.MISC, new ItemStack((ItemLike)repairKitItem), NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{repairKitItem}), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get())), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get())), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get()))})))));
        }
        reg.addRecipes(GEAR_CRAFTING_TYPE, SGearJeiPlugin.getRecipes(recipeManager, SGearJeiPlugin::isGearCraftingRecipe, CraftingRecipe.class));
        reg.addRecipes(TOOL_ACTION_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.TOOL_ACTION_TYPE.get(), ToolActionRecipe.class));
        reg.addRecipes(ALLOY_MAKING_FABRIC_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.ALLOY_MAKING_FABRIC_TYPE.get(), AlloyRecipe.class));
        reg.addRecipes(ALLOY_MAKING_GEM_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.ALLOY_MAKING_GEM_TYPE.get(), AlloyRecipe.class));
        reg.addRecipes(ALLOY_MAKING_METAL_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.ALLOY_MAKING_METAL_TYPE.get(), AlloyRecipe.class));
        reg.addRecipes(ALLOY_MAKING_SUPER_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.ALLOY_MAKING_SUPER_TYPE.get(), AlloyRecipe.class));
        for (int i = 2; i <= 4; ++i) {
            reg.addRecipes(ALLOY_MAKING_FABRIC_TYPE, Collections.singletonList(AlloyRecipe.makeExample(Const.FABRIC_ALLOY_MAKER_INFO, i, FabricAlloyRecipe::new)));
            reg.addRecipes(ALLOY_MAKING_GEM_TYPE, Collections.singletonList(AlloyRecipe.makeExample(Const.GEM_ALLOY_MAKER_INFO, i, GemAlloyRecipe::new)));
            reg.addRecipes(ALLOY_MAKING_METAL_TYPE, Collections.singletonList(AlloyRecipe.makeExample(Const.METAL_ALLOY_MAKER_INFO, i, MetalAlloyRecipe::new)));
            reg.addRecipes(ALLOY_MAKING_SUPER_TYPE, List.of(AlloyRecipe.makeExample(Const.SUPER_MIXER_INFO, i, SuperAlloyRecipe::new)));
        }
        reg.addRecipes(GRADING_TYPE, Collections.singletonList(new MaterialGraderRecipeCategory.GraderRecipe()));
        reg.addRecipes(SALVAGING_TYPE, SGearJeiPlugin.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)SgRecipes.SALVAGING_TYPE.get(), SalvagingRecipe.class));
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.RED_CARD_UPGRADE);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.SPOON_UPGRADE);
        for (Item item2 : SgItems.getItems(item -> item instanceof GearTool)) {
            SGearJeiPlugin.addInfoPage(reg, (ItemLike)item2);
        }
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeManager recipeManager, net.minecraft.world.item.crafting.RecipeType<?> recipeType, Class<R> recipeClass) {
        return SGearJeiPlugin.getRecipes(recipeManager, (? super RecipeHolder<?> r) -> r.value().getType() == recipeType, recipeClass);
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeManager recipeManager, RecipeSerializer<?> recipeSerializer, Class<R> recipeClass) {
        return SGearJeiPlugin.getRecipes(recipeManager, (? super RecipeHolder<?> r) -> r.value().getSerializer() == recipeSerializer, recipeClass);
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeManager recipeManager, Predicate<? super RecipeHolder<?>> predicate, Class<R> recipeClass) {
        return recipeManager.getRecipes().stream().filter(predicate).map(RecipeHolder::value).map(recipeClass::cast).collect(Collectors.toList());
    }

    private static boolean isGearCraftingRecipe(RecipeHolder<?> recipe) {
        RecipeSerializer serializer = recipe.value().getSerializer();
        return serializer == SgRecipes.SHAPED_GEAR.get() || serializer == SgRecipes.SHAPELESS_GEAR.get() || serializer == SgRecipes.COMPOUND_PART.get();
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), new RecipeType[]{GEAR_CRAFTING_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.REFABRICATOR), new RecipeType[]{ALLOY_MAKING_FABRIC_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.RECRYSTALLIZER), new RecipeType[]{ALLOY_MAKING_GEM_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.ALLOY_FORGE), new RecipeType[]{ALLOY_MAKING_METAL_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.SUPER_MIXER), new RecipeType[]{ALLOY_MAKING_SUPER_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.MATERIAL_GRADER), new RecipeType[]{GRADING_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.SALVAGER), new RecipeType[]{SALVAGING_TYPE});
        reg.addRecipeCatalyst(new ItemStack(SgBlocks.STONE_ANVIL), new RecipeType[]{TOOL_ACTION_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(RefabricatorScreen.class, 90, 30, 28, 23, new RecipeType[]{ALLOY_MAKING_FABRIC_TYPE});
        reg.addRecipeClickArea(RecrystallizerScreen.class, 90, 30, 28, 23, new RecipeType[]{ALLOY_MAKING_GEM_TYPE});
        reg.addRecipeClickArea(AlloyForgeScreen.class, 90, 30, 28, 23, new RecipeType[]{ALLOY_MAKING_METAL_TYPE});
        reg.addRecipeClickArea(SuperMixerScreen.class, 90, 30, 28, 23, new RecipeType[]{ALLOY_MAKING_SUPER_TYPE});
        reg.addRecipeClickArea(GraderScreen.class, 48, 30, 28, 23, new RecipeType[]{GRADING_TYPE});
        reg.addRecipeClickArea(SalvagerScreen.class, 30, 30, 28, 23, new RecipeType[]{SALVAGING_TYPE});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        ISubtypeInterpreter<ItemStack> customMaterials = new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return CustomMaterialItem.getMaterial(ingredient);
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                MaterialInstance material = CustomMaterialItem.getMaterial(ingredient);
                return material != null ? material.getId().toString() : "";
            }
        };
        reg.registerSubtypeInterpreter((Item)SgItems.CUSTOM_GEM.get(), (ISubtypeInterpreter)customMaterials);
        reg.registerSubtypeInterpreter((Item)SgItems.CUSTOM_INGOT.get(), (ISubtypeInterpreter)customMaterials);
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item) {
        String key = SGearJeiPlugin.getDescKey(NameUtils.fromItem((ItemLike)item));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, String name, Collection<ItemLike> items) {
        String key = SGearJeiPlugin.getDescKey(SilentGear.getId(name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item, Stream<ItemStack> variants) {
        String key = SGearJeiPlugin.getDescKey(NameUtils.fromItem((ItemLike)item));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.getNamespace() + "." + name.getPath() + ".desc";
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        for (Material material : SgRegistries.MATERIAL.getValues(true)) {
            List<ItemStack> itemStacks = Arrays.asList(material.getIngredient().getItems());
            ArrayList<String> aliases = new ArrayList<String>(List.of("materials"));
            for (IMaterialCategory category : material.getCategories(MaterialInstance.of(material))) {
                aliases.add("materials/" + category.getName());
            }
            registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, itemStacks, aliases);
        }
    }
}

