/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.IBlueprint;

public abstract class AbstractBlueprintItem
extends Item
implements IBlueprint {
    final BlueprintType type;

    AbstractBlueprintItem(Item.Properties properties, BlueprintType type) {
        super(properties);
        this.type = type;
        if (this.type == BlueprintType.BLUEPRINT) {
            properties.component(DataComponents.RARITY, (Object)Rarity.UNCOMMON);
        }
    }

    public abstract TagKey<Item> getItemTag();

    protected abstract Component getCraftedName(ItemStack var1);

    public boolean isSingleUse() {
        return this.type == BlueprintType.TEMPLATE;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack copy = itemStack.copy();
        copy.setCount(1);
        return copy;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.type == BlueprintType.BLUEPRINT;
    }

    boolean isDisabled() {
        BlueprintType.ConfigOption config = (BlueprintType.ConfigOption)((Object)Config.Common.blueprintTypes.get());
        return this.type == BlueprintType.TEMPLATE && !config.allowTemplate() || this.type == BlueprintType.BLUEPRINT && !config.allowBlueprint();
    }

    public Component getName(ItemStack stack) {
        String key = "item.silentgear." + this.type.name().toLowerCase(Locale.ROOT);
        return Component.translatable((String)key, (Object[])new Object[]{this.getCraftedName(stack)});
    }

    public boolean hasStandardModel() {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
    }
}

