/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;
import net.silentchaos512.gear.api.item.GearDiggerTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class GearDiggerItem
extends DiggerItem
implements GearDiggerTool {
    private final TagKey<Block> blocks;
    private final Supplier<GearType> gearType;

    public GearDiggerItem(Supplier<GearType> gearType, TagKey<Block> blocks, Item.Properties properties) {
        super((Tier)GearHelper.DEFAULT_DUMMY_TIER, blocks, properties);
        this.gearType = gearType;
        this.blocks = blocks;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public TagKey<Block> getToolBlockSet() {
        return this.blocks;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        if (GearHelper.isBroken(stack)) {
            return false;
        }
        return this.getGearType().canPerformAction(toolAction);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return GearHelper.getDestroySpeed(stack, state);
    }

    public InteractionResult useOn(UseOnContext context) {
        return GearHelper.onItemUse(context);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hurtEnemy(stack, target, attacker);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        GearHelper.postHurtEnemy(stack, target, attacker);
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entity) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entity);
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        GearHelper.addAttributeModifiers(stack, builder);
        return builder.build();
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantmentValue(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getProperties(stack).getNumberInt(GearProperties.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean isFoil(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, context, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

