/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.wrappers;

import com.almostreliable.lootjs.LootJS;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;

public class StatePropsPredicateWrapper {
    public static StatePropertiesPredicate of(@Nullable Object o) {
        if (o instanceof StatePropertiesPredicate) {
            StatePropertiesPredicate s = (StatePropertiesPredicate)o;
            return s;
        }
        if (!(o instanceof Map)) {
            throw new IllegalArgumentException("Invalid object for state properties. Given type: " + (o == null ? "NULL" : o.getClass().getName()));
        }
        Map map = (Map)o;
        ArrayList props = new ArrayList();
        StatePropsPredicateWrapper.loadMatchers(map, props::add);
        return new StatePropertiesPredicate(props);
    }

    private static void loadMatchers(Map<?, ?> map, Consumer<StatePropertiesPredicate.PropertyMatcher> onAdd) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getKey();
            if (!(obj instanceof String)) continue;
            String propertyName = (String)obj;
            Object unknownValue = entry.getValue();
            if (unknownValue instanceof Map) {
                Map minMaxValue = (Map)unknownValue;
                Optional<String> min = Optional.ofNullable(StatePropsPredicateWrapper.getSafePropertyValue(minMaxValue.get("min")));
                Optional<String> max = Optional.ofNullable(StatePropsPredicateWrapper.getSafePropertyValue(minMaxValue.get("max")));
                StatePropertiesPredicate.RangedMatcher matcher = new StatePropertiesPredicate.RangedMatcher(min, max);
                onAdd.accept(new StatePropertiesPredicate.PropertyMatcher(propertyName, (StatePropertiesPredicate.ValueMatcher)matcher));
                continue;
            }
            String value = StatePropsPredicateWrapper.getSafePropertyValue(unknownValue);
            if (value == null) {
                LootJS.LOG.warn("Can't validate value '" + String.valueOf(unknownValue) + "' for state properties. Skipping current property!");
                continue;
            }
            StatePropertiesPredicate.ExactMatcher matcher = new StatePropertiesPredicate.ExactMatcher(value);
            onAdd.accept(new StatePropertiesPredicate.PropertyMatcher(propertyName, (StatePropertiesPredicate.ValueMatcher)matcher));
        }
    }

    @Nullable
    private static String getSafePropertyValue(@Nullable Object o) {
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return Boolean.toString(b);
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return Integer.toString(n.intValue());
        }
        return null;
    }
}

