/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.filters.IdFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;

public interface Predicates {
    public static HolderLookup.Provider lookup() {
        return null;
    }

    public static EnchantmentPredicate enchantment(IdFilter filter) {
        return Predicates.enchantment(filter, MinMaxBounds.Ints.ANY);
    }

    public static EnchantmentPredicate enchantment(IdFilter filter, MinMaxBounds.Ints levelBound) {
        List<Holder.Reference> enchantments = Predicates.lookup().lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(ref -> filter.test(ref.key().location())).toList();
        HolderSet.Direct holderSet = HolderSet.direct(enchantments);
        return new EnchantmentPredicate(Optional.of(holderSet), levelBound);
    }

    public static ItemEnchantmentsPredicate itemEnchantments(EnchantmentPredicate[] predicates) {
        return ItemEnchantmentsPredicate.enchantments(Arrays.asList(predicates));
    }

    public static ItemEnchantmentsPredicate storedEnchantments(EnchantmentPredicate[] predicates) {
        return ItemEnchantmentsPredicate.storedEnchantments(Arrays.asList(predicates));
    }

    public static NbtPredicate nbt(CompoundTag nbt) {
        return new NbtPredicate(nbt);
    }
}

