/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import org.jetbrains.annotations.NotNull;

public class LinkFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "links";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken(Lexer.Token.lexFromChar(OpenLinkToken::new), '[');
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.tryConsume('(')) {
                return false;
            }
            String link = nibbler.consumeUntil(')');
            if (link == null) {
                return false;
            }
            tokens.add(new CloseLinkToken(link));
            return true;
        }, ']');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, left, tokens) -> {
            int pointer = tokens.pointer();
            Parser.Node content = parser.parseUntil(tokens, CloseLinkToken.class);
            Object patt0$temp = tokens.peek();
            if (patt0$temp instanceof CloseLinkToken) {
                CloseLinkToken right = (CloseLinkToken)patt0$temp;
                tokens.nibble();
                return new Parser.FormattingNode(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, right.link)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)right.link))).withColor(ChatFormatting.BLUE)).addChild(content);
            }
            tokens.setPointer(pointer);
            return new Parser.TextNode(left.content());
        }, (token, tokens) -> {
            OpenLinkToken link;
            return token instanceof OpenLinkToken ? (link = (OpenLinkToken)token) : null;
        });
    }

    private static final class OpenLinkToken
    extends Lexer.Token {
        public OpenLinkToken() {
            super("[");
        }
    }

    private static final class CloseLinkToken
    extends Lexer.Token {
        @NotNull
        public final String link;

        public CloseLinkToken(@NotNull String link) {
            super("](" + link + ")");
            this.link = link;
        }
    }
}

