/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.modular_accumulator;

import com.mrh0.createaddition.blocks.modular_accumulator.CAConnectivityHandler;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlock;
import com.mrh0.createaddition.blocks.modular_accumulator.ModularAccumulatorBlockEntity;
import com.mrh0.createaddition.index.CABlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ModularAccumulatorBlockItem
extends BlockItem {
    public ModularAccumulatorBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext ctx) {
        InteractionResult initialResult = super.place(ctx);
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        if (!face.getAxis().isVertical()) {
            return;
        }
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        BlockState placedOnState = world.getBlockState(placedOnPos = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (!ModularAccumulatorBlock.isAccumulator(placedOnState)) {
            return;
        }
        ModularAccumulatorBlockEntity accumulatorAt = (ModularAccumulatorBlockEntity)CAConnectivityHandler.partAt((BlockEntityType)CABlockEntities.MODULAR_ACCUMULATOR.get(), (BlockGetter)world, placedOnPos);
        if (accumulatorAt == null) {
            return;
        }
        ModularAccumulatorBlockEntity controllerTE = accumulatorAt.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        int width = controllerTE.width;
        if (width == 1) {
            return;
        }
        int blocksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerTE.getBlockPos().below() : controllerTE.getBlockPos().above(controllerTE.height);
        if (startPos.getY() != pos.getY()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.offset(xOffset, 0, zOffset);
                blockState = world.getBlockState(offsetPos);
                if (ModularAccumulatorBlock.isAccumulator(blockState)) continue;
                if (!blockState.canBeReplaced()) {
                    return;
                }
                ++blocksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < blocksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.offset(xOffset, 0, zOffset);
                blockState = world.getBlockState(offsetPos);
                if (ModularAccumulatorBlock.isAccumulator(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().putBoolean("SilenceTankSound", true);
                super.place(context);
                player.getPersistentData().remove("SilenceTankSound");
            }
        }
    }
}

