/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.index.CAItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum WireType {
    COPPER(0, 256, 78, 37, 30, CAItems.COPPER_WIRE.asStack(4), CAItems.COPPER_SPOOL.asStack()),
    GOLD(1, 1024, 98, 83, 29, CAItems.GOLD_WIRE.asStack(4), CAItems.GOLD_SPOOL.asStack()),
    ELECTRUM(2, 8196, 88, 66, 37, CAItems.ELECTRUM_WIRE.asStack(4), CAItems.ELECTRUM_SPOOL.asStack()),
    FESTIVE(3, 256, 26, 94, 12, CAItems.COPPER_WIRE.asStack(4), CAItems.FESTIVE_SPOOL.asStack());

    private final int ID;
    private final int TRANSFER;
    private final int CR;
    private final int CG;
    private final int CB;
    private final ItemStack DROP;
    private final ItemStack SOURCE_DROP;

    private WireType(int id, int transfer, int red, int green, int blue, ItemStack drop, ItemStack source) {
        this.ID = id;
        this.TRANSFER = transfer;
        this.CR = red;
        this.CG = green;
        this.CB = blue;
        this.DROP = drop;
        this.SOURCE_DROP = source;
    }

    public static WireType fromIndex(int index) {
        return switch (index) {
            case 0 -> COPPER;
            case 1 -> GOLD;
            case 2 -> ELECTRUM;
            case 3 -> FESTIVE;
            default -> null;
        };
    }

    public int getIndex() {
        return this.ID;
    }

    public ItemStack getDrop() {
        return this.DROP.copy();
    }

    public ItemStack getSourceDrop() {
        return this.SOURCE_DROP.copy();
    }

    public int transfer() {
        return this.TRANSFER;
    }

    public int getRed() {
        return this.CR;
    }

    public int getGreen() {
        return this.CG;
    }

    public int getBlue() {
        return this.CB;
    }

    public boolean isFestive() {
        return this == FESTIVE;
    }

    public static WireType of(Item item) {
        if (item == CAItems.COPPER_SPOOL.get()) {
            return COPPER;
        }
        if (item == CAItems.GOLD_SPOOL.get()) {
            return GOLD;
        }
        if (item == CAItems.FESTIVE_SPOOL.get()) {
            return FESTIVE;
        }
        if (item == CAItems.ELECTRUM_SPOOL.get()) {
            return ELECTRUM;
        }
        return COPPER;
    }
}

