/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionCompleteEvent;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.api.properties.CustomPokemonPropertyType;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.data.CobblemonDataProvider;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.platform.events.ChangeDimensionEvent;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerPlayerEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerPlayer;
import net.starliteheart.cobbleride.common.CobbleRideModImpl;
import net.starliteheart.cobbleride.common.api.pokemon.RideablePokemonSpecies;
import net.starliteheart.cobbleride.common.config.CobbleRideConfig;
import net.starliteheart.cobbleride.common.entity.pokemon.RideablePokemonEntity;
import net.starliteheart.cobbleride.common.net.messages.client.pokemon.ai.ClientMoveBehaviour;
import net.starliteheart.cobbleride.common.net.messages.client.pokemon.sync.UpdatePokemonBehaviourPacket;
import net.starliteheart.cobbleride.common.net.messages.client.settings.SendServerSettingsPacket;
import net.starliteheart.cobbleride.common.pokemon.properties.SaddledProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003R\u0014\u0010\u0012\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\b\u00a8\u0006&"}, d2={"Lnet/starliteheart/cobbleride/common/CobbleRideMod;", "", "<init>", "()V", "Lnet/starliteheart/cobbleride/common/CobbleRideModImpl;", "implementation", "", "initialize", "(Lnet/starliteheart/cobbleride/common/CobbleRideModImpl;)V", "loadConfig", "Lcom/google/gson/JsonObject;", "defaultConfig", "fileConfig", "Lcom/google/gson/JsonElement;", "mergeConfigs", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonElement;", "saveConfig", "", "MOD_ID", "Ljava/lang/String;", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "setLOGGER", "(Lorg/apache/logging/log4j/Logger;)V", "Lnet/starliteheart/cobbleride/common/config/CobbleRideConfig;", "config", "Lnet/starliteheart/cobbleride/common/config/CobbleRideConfig;", "getConfig", "()Lnet/starliteheart/cobbleride/common/config/CobbleRideConfig;", "setConfig", "(Lnet/starliteheart/cobbleride/common/config/CobbleRideConfig;)V", "Lnet/starliteheart/cobbleride/common/CobbleRideModImpl;", "getImplementation", "()Lnet/starliteheart/cobbleride/common/CobbleRideModImpl;", "setImplementation", "cobbleride-common"})
public final class CobbleRideMod {
    @NotNull
    public static final CobbleRideMod INSTANCE = new CobbleRideMod();
    @NotNull
    public static final String MOD_ID = "cobbleride";
    @NotNull
    private static Logger LOGGER;
    public static CobbleRideConfig config;
    public static CobbleRideModImpl implementation;

    private CobbleRideMod() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final void setLOGGER(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        LOGGER = logger;
    }

    @NotNull
    public final CobbleRideConfig getConfig() {
        CobbleRideConfig cobbleRideConfig = config;
        if (cobbleRideConfig != null) {
            return cobbleRideConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull CobbleRideConfig cobbleRideConfig) {
        Intrinsics.checkNotNullParameter((Object)cobbleRideConfig, (String)"<set-?>");
        config = cobbleRideConfig;
    }

    @NotNull
    public final CobbleRideModImpl getImplementation() {
        CobbleRideModImpl cobbleRideModImpl = implementation;
        if (cobbleRideModImpl != null) {
            return cobbleRideModImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"implementation");
        return null;
    }

    public final void setImplementation(@NotNull CobbleRideModImpl cobbleRideModImpl) {
        Intrinsics.checkNotNullParameter((Object)cobbleRideModImpl, (String)"<set-?>");
        implementation = cobbleRideModImpl;
    }

    public final void initialize(@NotNull CobbleRideModImpl implementation) {
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        this.setImplementation(implementation);
        CobblemonDataProvider.INSTANCE.register((DataRegistry)RideablePokemonSpecies.INSTANCE);
        CustomPokemonProperty.Companion.register((CustomPokemonPropertyType)SaddledProperty.INSTANCE);
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)PlatformEvents.CHANGE_DIMENSION), null, CobbleRideMod::initialize$lambda$0, (int)1, null);
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)PlatformEvents.SERVER_PLAYER_LOGOUT), null, CobbleRideMod::initialize$lambda$1, (int)1, null);
        this.loadConfig();
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)CobblemonEvents.DATA_SYNCHRONIZED), null, CobbleRideMod::initialize$lambda$2, (int)1, null);
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)CobblemonEvents.EVOLUTION_COMPLETE), null, CobbleRideMod::initialize$lambda$3, (int)1, null);
    }

    private final void loadConfig() {
        String configFileLoc = System.getProperty("user.dir") + File.separator + "config" + File.separator + MOD_ID + File.separator + "config.json";
        LOGGER.info("Loading config file found at: " + configFileLoc);
        File configFile = new File(configFileLoc);
        configFile.getParentFile().mkdirs();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                CobbleRideConfig defaultConfig = new CobbleRideConfig();
                String string = CobbleRideConfig.Companion.getGSON().toJson((Object)defaultConfig);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                String defaultConfigJson = string;
                JsonElement jsonElement = JsonParser.parseReader((Reader)fileReader);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseReader(...)");
                JsonElement fileConfigElement = jsonElement;
                JsonElement jsonElement2 = JsonParser.parseString((String)defaultConfigJson);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"parseString(...)");
                JsonElement defaultConfigElement = jsonElement2;
                JsonObject jsonObject = defaultConfigElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                JsonObject jsonObject2 = fileConfigElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
                JsonElement mergedConfigElement = this.mergeConfigs(jsonObject, jsonObject2);
                Object object = CobbleRideConfig.Companion.getGSON().fromJson(mergedConfigElement, CobbleRideConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                CobbleRideConfig finalConfig = (CobbleRideConfig)object;
                CobbleRideConfig.Companion.validate(finalConfig);
                this.setConfig(finalConfig);
                fileReader.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load the config! Using default config as fallback.");
                e.printStackTrace();
                this.setConfig(new CobbleRideConfig());
            }
        } else {
            this.setConfig(new CobbleRideConfig());
        }
        this.saveConfig();
    }

    private final JsonElement mergeConfigs(JsonObject defaultConfig, JsonObject fileConfig) {
        LOGGER.info("Checking for config merge.");
        boolean merged = false;
        for (String key : defaultConfig.keySet()) {
            if (!fileConfig.has(key)) {
                fileConfig.add(key, defaultConfig.get(key));
                LOGGER.info(key + " not found in file config, adding from default.");
                merged = true;
                continue;
            }
            if (!defaultConfig.get(key).isJsonObject() || !fileConfig.get(key).isJsonObject()) continue;
            JsonObject jsonObject = defaultConfig.getAsJsonObject(key);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            JsonObject jsonObject2 = fileConfig.getAsJsonObject(key);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
            this.mergeConfigs(jsonObject, jsonObject2);
        }
        if (merged) {
            LOGGER.info("Successfully merged config!");
        }
        return (JsonElement)fileConfig;
    }

    private final void saveConfig() {
        try {
            String configFileLoc = System.getProperty("user.dir") + File.separator + "config" + File.separator + MOD_ID + File.separator + "config.json";
            LOGGER.info("Saving config to: " + configFileLoc);
            File configFile = new File(configFileLoc);
            FileWriter fileWriter = new FileWriter(configFile);
            CobbleRideConfig.Companion.getGSON().toJson((Object)this.getConfig(), (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config!");
            e.printStackTrace();
        }
    }

    private static final Unit initialize$lambda$0(ChangeDimensionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getPlayer().getVehicle() instanceof RideablePokemonEntity) {
            it.getPlayer().removeVehicle();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(ServerPlayerEvent.Logout it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getPlayer().getVehicle() instanceof RideablePokemonEntity) {
            it.getPlayer().removeVehicle();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new SendServerSettingsPacket(INSTANCE.getConfig()).sendToPlayer(it);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3(EvolutionCompleteEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PokemonEntity entity = it.getPokemon().getEntity();
        if (entity instanceof RideablePokemonEntity) {
            ClientMoveBehaviour behaviour = new ClientMoveBehaviour(((RideablePokemonEntity)entity).getExposedForm().getBehaviour().getMoving());
            ((RideablePokemonEntity)entity).setMoveBehaviour(behaviour);
            CobblemonNetwork.INSTANCE.sendToAllPlayers((NetworkPacket)new UpdatePokemonBehaviourPacket(((RideablePokemonEntity)entity).getId(), behaviour));
        }
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

