/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.mixin;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.starliteheart.cobbleride.common.entity.pokemon.RideablePokemonEntity;
import net.starliteheart.cobbleride.common.net.messages.client.ui.InteractUnownedPokemonUIPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin {
    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lcom/cobblemon/mod/common/net/messages/client/ui/InteractPokemonUIPacket;sendToPlayer(Lnet/minecraft/server/level/ServerPlayer;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void consumeInteractWheelAction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/ShoulderRidingEntity;mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")}, cancellable=true)
    private void useInteractRidePokemonUIForNonOwners(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        PokemonEntity entity = (PokemonEntity)this;
        Pokemon pokemon = entity.getPokemon();
        if (hand == InteractionHand.MAIN_HAND && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (pokemon.isPlayerOwned() && entity instanceof RideablePokemonEntity) {
                RideablePokemonEntity rideable = (RideablePokemonEntity)entity;
                if (player.isShiftKeyDown() && rideable.canBeRiddenBy(player) && !rideable.hasPassenger((Entity)player)) {
                    new InteractUnownedPokemonUIPacket(entity.getUUID()).sendToPlayer(serverPlayer);
                    cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
                }
            }
        }
    }
}

