/*
 * Decompiled with CFR 0.152.
 */
package net.starliteheart.cobbleride.common.net.serverhandling.pokemon.interact;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.starliteheart.cobbleride.common.CobbleRideMod;
import net.starliteheart.cobbleride.common.entity.pokemon.RideablePokemonEntity;
import net.starliteheart.cobbleride.common.mixin.accessor.EntityAccessor;
import net.starliteheart.cobbleride.common.net.messages.client.entity.sync.UpdateEntityRotPacket;
import net.starliteheart.cobbleride.common.net.messages.client.entity.sync.UpdatePlayerCameraPacket;
import net.starliteheart.cobbleride.common.net.messages.server.pokemon.interact.MountPokemonPacket;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/starliteheart/cobbleride/common/net/serverhandling/pokemon/interact/MountPokemonHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lnet/starliteheart/cobbleride/common/net/messages/server/pokemon/interact/MountPokemonPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lnet/starliteheart/cobbleride/common/net/messages/server/pokemon/interact/MountPokemonPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "cobbleride-common"})
public final class MountPokemonHandler
implements ServerNetworkPacketHandler<MountPokemonPacket> {
    public void handle(@NotNull MountPokemonPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Entity entity = player.serverLevel().getEntity(packet.getPokemonID());
        if (entity instanceof RideablePokemonEntity) {
            if (packet.isMounting()) {
                if (!((RideablePokemonEntity)entity).canBeRiddenBy((Player)player)) {
                    player.displayClientMessage((Component)Component.translatable((String)"cobbleride.message.system.interact.not_rideable"), true);
                } else if (CobbleRideMod.INSTANCE.getConfig().getRestrictions().isSaddleRequired() && !((RideablePokemonEntity)entity).isSaddled()) {
                    Object[] objectArray = new Object[]{((RideablePokemonEntity)entity).getDisplayName()};
                    player.displayClientMessage((Component)Component.translatable((String)"cobbleride.message.system.interact.saddle_required", (Object[])objectArray), true);
                } else if (!((RideablePokemonEntity)entity).canAddPassenger((Entity)player) && !((RideablePokemonEntity)entity).isOwnedBy((LivingEntity)player)) {
                    Object[] objectArray = new Object[]{((RideablePokemonEntity)entity).getDisplayName()};
                    player.displayClientMessage((Component)Component.translatable((String)"cobbleride.message.system.interact.no_empty_seats", (Object[])objectArray), true);
                } else if (((RideablePokemonEntity)entity).hasPassenger((Entity)player)) {
                    Object[] objectArray = new Object[]{((RideablePokemonEntity)entity).getDisplayName()};
                    player.displayClientMessage((Component)Component.translatable((String)"cobbleride.message.system.interact.already_mounted", (Object[])objectArray), true);
                } else {
                    Object[] objectArray = new Object[]{player.getDisplayName(), ((RideablePokemonEntity)entity).getName(), ((RideablePokemonEntity)entity).getX(), ((RideablePokemonEntity)entity).getY(), ((RideablePokemonEntity)entity).getZ()};
                    CobbleRideMod.INSTANCE.getLOGGER().debug(Component.translatable((String)"cobbleride.message.server.debug.mount", (Object[])objectArray).getString());
                    player.setYRot(((RideablePokemonEntity)entity).getYRot());
                    player.setXRot(((RideablePokemonEntity)entity).getXRot());
                    CobblemonNetwork.INSTANCE.sendToAllPlayers((NetworkPacket)new UpdateEntityRotPacket(player.getId(), ((RideablePokemonEntity)entity).getYRot(), ((RideablePokemonEntity)entity).getXRot()));
                    if (!((RideablePokemonEntity)entity).canAddPassenger((Entity)player)) {
                        Logger logger = CobbleRideMod.INSTANCE.getLOGGER();
                        objectArray = new Object[5];
                        List list = ((RideablePokemonEntity)entity).getPassengers();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
                        objectArray[0] = CollectionsKt.last((List)list);
                        objectArray[1] = ((RideablePokemonEntity)entity).getName();
                        objectArray[2] = ((RideablePokemonEntity)entity).getX();
                        objectArray[3] = ((RideablePokemonEntity)entity).getY();
                        objectArray[4] = ((RideablePokemonEntity)entity).getZ();
                        logger.debug(Component.translatable((String)"cobbleride.message.server.debug.dismount", (Object[])objectArray).getString());
                        List list2 = ((RideablePokemonEntity)entity).getPassengers();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPassengers(...)");
                        ((Entity)CollectionsKt.last((List)list2)).stopRiding();
                    }
                    player.startRiding(entity, ((EntityAccessor)player).getBoardingCooldown() <= 0);
                    CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, (NetworkPacket)new UpdatePlayerCameraPacket(true));
                }
            } else if (!((RideablePokemonEntity)entity).isVehicle()) {
                Object[] objectArray = new Object[]{((RideablePokemonEntity)entity).getDisplayName()};
                player.displayClientMessage((Component)Component.translatable((String)"cobbleride.message.system.interact.no_passengers", (Object[])objectArray), true);
            } else {
                ((RideablePokemonEntity)entity).ejectPassengers();
            }
        }
    }
}

