/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.network.ChorusTotemUsedPacket;
import artifacts.network.DoubleJumpPacket;
import artifacts.network.PlaySoundAtPlayerPacket;
import artifacts.network.SwimPacket;
import artifacts.network.ToggleKeyPressedPacket;
import artifacts.network.UpdateItemConfigPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NetworkHandler {
    public static final List<PayloadHandler<?>> SERVERBOUND_HANDLERS = new ArrayList();
    public static final List<PayloadHandler<?>> CLIENTBOUND_HANDLERS = new ArrayList();

    public static void initPayloads() {
        NetworkHandler.registerClientbound(ChorusTotemUsedPacket.TYPE, ChorusTotemUsedPacket.CODEC, ChorusTotemUsedPacket::apply);
        NetworkHandler.registerClientbound(PlaySoundAtPlayerPacket.TYPE, PlaySoundAtPlayerPacket.CODEC, PlaySoundAtPlayerPacket::apply);
        NetworkHandler.registerClientbound(UpdateItemConfigPacket.TYPE, UpdateItemConfigPacket.CODEC, UpdateItemConfigPacket::apply);
        NetworkHandler.registerClientbound(SwimPacket.TYPE, SwimPacket.CODEC, SwimPacket::apply);
        NetworkHandler.registerServerbound(DoubleJumpPacket.TYPE, DoubleJumpPacket.CODEC, DoubleJumpPacket::apply);
        NetworkHandler.registerServerbound(SwimPacket.TYPE, SwimPacket.CODEC, SwimPacket::apply);
        NetworkHandler.registerServerbound(ToggleKeyPressedPacket.TYPE, ToggleKeyPressedPacket.CODEC, ToggleKeyPressedPacket::apply);
    }

    private static <T extends CustomPacketPayload> void registerServerbound(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, Receiver<T> receiver) {
        SERVERBOUND_HANDLERS.add(new PayloadHandler<T>(type, codec, receiver));
    }

    private static <T extends CustomPacketPayload> void registerClientbound(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, Receiver<T> receiver) {
        CLIENTBOUND_HANDLERS.add(new PayloadHandler<T>(type, codec, receiver));
    }

    public static void sendToServer(CustomPacketPayload payload) {
        ClientPacketListener listener = Objects.requireNonNull(Minecraft.getInstance().getConnection());
        listener.send((Packet)new ServerboundCustomPayloadPacket(payload));
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, CustomPacketPayload payload) {
        for (ServerPlayer player : players) {
            NetworkHandler.sendToPlayer(player, payload);
        }
    }

    public static void sendToPlayer(ServerPlayer player, CustomPacketPayload payload) {
        player.connection.send((Packet)new ClientboundCustomPayloadPacket(payload));
    }

    @FunctionalInterface
    public static interface Receiver<T extends CustomPacketPayload> {
        public void receive(T var1, PayloadContext var2);
    }

    public record PayloadHandler<T extends CustomPacketPayload>(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, Receiver<T> receiver) {
    }

    public static interface PayloadContext {
        public Player player();

        public void queue(Runnable var1);
    }
}

