/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.CaptureBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ?\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastCapture;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/core/BlockPos;", "coords", "Lnet/minecraft/resources/ResourceLocation;", "biome", "dimension", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/server/level/ServerPlayer;", "player", "broadcast", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;)V", "cobblemon-spawn-notification"})
public final class BroadcastCapture {
    @NotNull
    public static final BroadcastCapture INSTANCE = new BroadcastCapture();

    private BroadcastCapture() {
    }

    public final void handle(@NotNull PokemonCapturedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastCaptures()) {
            return;
        }
        EmptyPokeBallEntity entity = evt.getPokeBallEntity();
        BlockPos coords = entity.blockPosition();
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Pokemon pokemon = evt.getPokemon();
        Intrinsics.checkNotNull((Object)coords);
        ResourceLocation resourceLocation = ((ResourceKey)((ServerLevel)level).getBiome(coords).unwrapKey().get()).location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        ResourceLocation resourceLocation2 = ((ServerLevel)level).dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        this.broadcast(pokemon, coords, resourceLocation, resourceLocation2, (ServerLevel)level, evt.getPlayer());
    }

    private final void broadcast(Pokemon pokemon, BlockPos coords, ResourceLocation biome, ResourceLocation dimension, ServerLevel level, ServerPlayer player) {
        block4: {
            Component component = new CaptureBroadcaster(pokemon, coords, biome, dimension, player).getBroadcast();
            if (component == null) break block4;
            Component message = component;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
            } else if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                ResourceKey resourceKey = level.dimension();
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers((ResourceKey<Level>)resourceKey, coords), message);
            } else {
                Broadcast.INSTANCE.broadcastMessage(level, message);
            }
        }
    }
}

