/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.DespawnBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastDespawn;", "", "<init>", "()V", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/server/level/ServerLevel;", "level", "", "handle", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerLevel;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/core/BlockPos;", "coords", "Lnet/minecraft/resources/ResourceLocation;", "biome", "dimension", "broadcast", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerLevel;)V", "cobblemon-spawn-notification"})
public final class BroadcastDespawn {
    @NotNull
    public static final BroadcastDespawn INSTANCE = new BroadcastDespawn();

    private BroadcastDespawn() {
    }

    public final void handle(@NotNull Entity entity, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastVolatileDespawns()) {
            return;
        }
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        if (((PokemonEntity)entity).getPersistentData().contains("spawn_notification:should_broadcast_faint")) {
            return;
        }
        BlockPos coords = entity.blockPosition();
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        Intrinsics.checkNotNull((Object)coords);
        ResourceLocation resourceLocation = ((ResourceKey)level.getBiome(coords).unwrapKey().get()).location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        ResourceLocation resourceLocation2 = level.dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        this.broadcast(pokemon, coords, resourceLocation, resourceLocation2, level);
    }

    private final void broadcast(Pokemon pokemon, BlockPos coords, ResourceLocation biome, ResourceLocation dimension, ServerLevel level) {
        block4: {
            Component component = new DespawnBroadcaster(pokemon, coords, biome, dimension).getBroadcast();
            if (component == null) break block4;
            Component message = component;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
            } else if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                ResourceKey resourceKey = level.dimension();
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers((ResourceKey<Level>)resourceKey, coords), message);
            } else {
                Broadcast.INSTANCE.broadcastMessage(level, message);
            }
        }
    }
}

