/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundOpenScreenPacket;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface IScreenProvider {
    @OnlyIn(value=Dist.CLIENT)
    default public void openScreen(Level level, Player player, Direction direction) {
    }

    default public void sendOpenGuiPacket(ServerPlayer player, @Nullable Direction hitFace) {
        TileOrEntityTarget target;
        IScreenProvider iScreenProvider = this;
        if (iScreenProvider instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iScreenProvider;
            target = TileOrEntityTarget.of(be);
        } else {
            iScreenProvider = this;
            if (iScreenProvider instanceof Player) {
                Player entity = (Player)iScreenProvider;
                target = TileOrEntityTarget.of((Entity)entity);
            } else {
                throw new IllegalStateException("IScreenProvider must be a BlockEntity or Entity");
            }
        }
        NetworkHelper.sendToClientPlayer(player, new ClientBoundOpenScreenPacket(target, hitFace));
    }
}

