/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.neoforge;

import com.google.gson.JsonElement;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.ExtendedBlockModelDeserializer;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;

public class ClientHelperImpl {
    public static void registerRenderType(Block block, RenderType ... types) {
        if (types.length == 1) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)types[0]);
        } else {
            List<RenderType> l = List.of(types);
            ItemBlockRenderTypes.setRenderLayer((Block)block, l::contains);
        }
    }

    public static void registerFluidRenderType(Fluid fluid, RenderType type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
    }

    public static void addParticleRegistration(Consumer<ClientHelper.ParticleEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterParticleProvidersEvent> eventConsumer = event -> eventListener.accept(new ParticleEventImpl((RegisterParticleProvidersEvent)event));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addEntityRenderersRegistration(Consumer<ClientHelper.EntityRendererEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<EntityRenderersEvent.RegisterRenderers> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addBlockEntityRenderersRegistration(Consumer<ClientHelper.BlockEntityRendererEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<EntityRenderersEvent.RegisterRenderers> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addBlockColorsRegistration(Consumer<ClientHelper.BlockColorEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterColorHandlersEvent.Block> eventConsumer = event -> eventListener.accept(new ClientHelper.BlockColorEvent((RegisterColorHandlersEvent.Block)event){
            final /* synthetic */ RegisterColorHandlersEvent.Block val$event;
            {
                this.val$event = block;
            }

            @Override
            public void register(BlockColor color, Block ... block) {
                this.val$event.register(color, block);
            }

            @Override
            public int getColor(BlockState block, BlockAndTintGetter level, BlockPos pos, int tint) {
                return this.val$event.getBlockColors().getColor(block, level, pos, tint);
            }
        });
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addItemColorsRegistration(Consumer<ClientHelper.ItemColorEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterColorHandlersEvent.Item> eventConsumer = event -> eventListener.accept(new ClientHelper.ItemColorEvent((RegisterColorHandlersEvent.Item)event){
            final /* synthetic */ RegisterColorHandlersEvent.Item val$event;
            {
                this.val$event = item;
            }

            @Override
            public void register(ItemColor color, ItemLike ... items) {
                this.val$event.register(color, items);
            }

            @Override
            public int getColor(ItemStack stack, int tint) {
                return this.val$event.getItemColors().getColor(stack, tint);
            }
        });
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addClientReloadListener(Supplier<PreparableReloadListener> listener, ResourceLocation location) {
        Moonlight.assertInitPhase();
        Consumer<RegisterClientReloadListenersEvent> eventConsumer = event -> event.registerReloadListener((PreparableReloadListener)listener.get());
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addModelLayerRegistration(Consumer<ClientHelper.ModelLayerEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<EntityRenderersEvent.RegisterLayerDefinitions> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addSpecialModelRegistration(Consumer<ClientHelper.SpecialModelEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<ModelEvent.RegisterAdditional> eventConsumer = event -> eventListener.accept(new ClientHelper.SpecialModelEvent((ModelEvent.RegisterAdditional)event){
            final /* synthetic */ ModelEvent.RegisterAdditional val$event;
            {
                this.val$event = registerAdditional;
            }

            @Override
            public void register(ModelResourceLocation modelLocation) {
                this.val$event.register(modelLocation);
            }

            @Override
            public void register(ResourceLocation id) {
                this.val$event.register(ModelResourceLocation.standalone((ResourceLocation)id));
            }
        });
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addTooltipComponentRegistration(Consumer<ClientHelper.TooltipComponentEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterClientTooltipComponentFactoriesEvent> eventConsumer = event -> eventListener.accept((arg_0, arg_1) -> ((RegisterClientTooltipComponentFactoriesEvent)event).register(arg_0, arg_1));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addModelLoaderRegistration(Consumer<ClientHelper.ModelLoaderEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<ModelEvent.RegisterGeometryLoaders> eventConsumer = event -> eventListener.accept((i, l) -> event.register(i, (IGeometryLoader)l));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addItemDecoratorsRegistration(Consumer<ClientHelper.ItemDecoratorEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterItemDecorationsEvent> eventConsumer = event -> eventListener.accept((i, l) -> {
            IItemDecorator deco = new IItemDecorator(){

                public boolean render(GuiGraphics graphics, Font font, ItemStack stack, int xOffset, int yOffset) {
                    return l.render(graphics, font, stack, xOffset, yOffset);
                }
            };
            event.register(i, deco);
        });
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addKeyBindRegistration(Consumer<ClientHelper.KeyBindEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterKeyMappingsEvent> eventConsumer = event -> eventListener.accept(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static int getPixelRGBA(TextureAtlasSprite sprite, int frameIndex, int x, int y) {
        return sprite.getPixelRGBA(frameIndex, x, y);
    }

    public static BakedModel getModel(ModelManager modelManager, ModelResourceLocation modelLocation) {
        return modelManager.getModel(modelLocation);
    }

    @Nullable
    public static Path getModIcon(String modId) {
        Optional m = ModList.get().getModContainerById(modId);
        if (m.isPresent()) {
            Path logoPath;
            IModInfo mod = ((ModContainer)m.get()).getModInfo();
            IModFile file = mod.getOwningFile().getFile();
            String logo = mod.getLogoFile().orElse(null);
            if (logo != null && file != null && Files.exists(logoPath = file.findResource(new String[]{logo}), new LinkOption[0])) {
                return logoPath;
            }
        }
        return null;
    }

    public static BlockModel parseBlockModel(JsonElement json) {
        return (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.getAdapter(BlockModel.class).fromJsonTree(json);
    }

    public static void addClientSetup(Runnable clientSetup) {
        Moonlight.assertInitPhase();
        Consumer<FMLClientSetupEvent> eventConsumer = event -> event.enqueueWork(clientSetup);
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addClientSetupAsync(Runnable clientSetup) {
        Moonlight.assertInitPhase();
        Consumer<FMLClientSetupEvent> eventConsumer = event -> clientSetup.run();
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void registerOptionalTexturePack(ResourceLocation folderName, Component displayName, boolean defaultEnabled) {
        Moonlight.assertInitPhase();
        PlatHelper.registerResourcePack(PackType.CLIENT_RESOURCES, () -> {
            Pack pack;
            IModFile file = ModList.get().getModFileById(folderName.getNamespace()).getFile();
            PackLocationInfo locationInfo = new PackLocationInfo(folderName.toString(), displayName, PackSource.BUILT_IN, Optional.empty());
            final PathPackResources pack2 = new PathPackResources(locationInfo, file.findResource(new String[]{"resourcepacks/" + folderName.getPath()}));
            try {
                pack = Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                    public PackResources openPrimary(PackLocationInfo location) {
                        return pack2;
                    }

                    public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                        return pack2;
                    }
                }, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(defaultEnabled, Pack.Position.TOP, false));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        pack2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ee) {
                    if (!DatagenModLoader.isRunningDataGen()) {
                        ee.printStackTrace();
                    }
                    return null;
                }
            }
            pack2.close();
            return pack;
        });
    }

    public static void addShaderRegistration(Consumer<ClientHelper.ShaderEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterShadersEvent> eventConsumer = event -> eventListener.accept((id, vertexFormat, setter) -> {
            try {
                ShaderInstance shader = new ShaderInstance(event.getResourceProvider(), id, vertexFormat);
                event.registerShader(shader, setter);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse shader: " + String.valueOf(id), e);
            }
        });
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addItemRenderersRegistration(Consumer<ClientHelper.ItemRendererEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterClientExtensionsEvent> eventConsumer = event -> eventListener.accept((item, renderer) -> {
            final ItemStackRenderer rend = renderer.getItemRenderer();
            event.registerItem(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    if (rend != null) {
                        return rend;
                    }
                    return super.getCustomRenderer();
                }

                public void renderHelmetOverlay(ItemStack stack, Player player, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
                    renderer.renderHelmetOverlay(stack, player, guiGraphics, deltaTracker);
                }
            }, new Item[]{item.asItem()});
        });
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    private record ParticleEventImpl(RegisterParticleProvidersEvent event) implements ClientHelper.ParticleEvent
    {
        @Override
        public <P extends ParticleType<T>, T extends ParticleOptions> void register(P type, ClientHelper.ParticleFactory<T> provider) {
            this.event.registerSpriteSet(type, provider::create);
        }
    }
}

