/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.mehvahdjukaar.moonlight.api.resources.pack.AbstractCachedEditableResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.FastSearchFilePackResources;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import org.apache.commons.io.FileUtils;

public class CacheZipPackResources
extends AbstractCachedEditableResources {
    private final Map<ResourceLocation, byte[]> tempResources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    private volatile boolean dirty = false;

    public CacheZipPackResources(PackLocationInfo location, PackType type, Path path) {
        super(!path.getFileName().toString().endsWith(".zip") ? path.resolveSibling(String.valueOf(path.getFileName()) + ".zip") : path, location, type, (Component)Component.translatable((String)"message.moonlight.cached_zipped"));
    }

    @Override
    public void addResource(ResourceLocation id, byte[] bytes) {
        this.tempResources.put(id, bytes);
        this.dirty = true;
    }

    @Override
    public void removeResource(ResourceLocation id) {
        this.tempResources.remove(id);
        this.dirty = true;
    }

    @Override
    public void removeRootResource(String name) {
    }

    @Override
    public boolean clearAllResources() {
        boolean gone;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (this.cachedResources != null) {
                this.cachedResources.close();
            }
            this.cachedResources = null;
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)this.path.toFile());
            } else {
                Files.deleteIfExists(this.path);
            }
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to clear zipped cached resource pack at {}", (Object)this.path, (Object)e);
        }
        boolean bl = gone = !Files.exists(this.path, new LinkOption[0]);
        if (!gone) {
            Moonlight.LOGGER.error("Failed to delete cached resource pack at {}", (Object)this.path);
        }
        Moonlight.LOGGER.info("Cleared zipped cached resource pack at {} in {}", (Object)this.path, (Object)stopwatch);
        return gone;
    }

    @Override
    public boolean initializeIfValid() {
        boolean cacheExists;
        if (Files.exists(this.path, new LinkOption[0]) && Files.isDirectory(this.path, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)this.path.toFile());
            }
            catch (IOException e) {
                Moonlight.LOGGER.warn("Could not remove directory at zip path {}: {}", (Object)this.path, (Object)e.toString());
                return false;
            }
        }
        if (cacheExists = Files.isRegularFile(this.path, new LinkOption[0])) {
            this.cachedResources = CommonConfigs.FASTER_CACHE_SEARCH.get() != false ? new FastSearchFilePackResources(this.locationInfo, this.path.toFile(), this.packType) : new FilePackResources.FileResourcesSupplier(this.path.toFile()).openPrimary(this.locationInfo);
        }
        return cacheExists;
    }

    @Override
    public PackType getPackType() {
        return this.packType;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void commitChanges() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        if (this.cachedResources != null) {
            Moonlight.LOGGER.error("Zip file resources was not cleared before commit. Clearing now.");
            if (!this.clearAllResources()) {
                throw new RuntimeException("Could not clear resources before writing zip");
            }
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.writeZipPreferStored(this.tempResources, this.path);
            this.tempResources.clear();
            this.initializeIfValid();
            Moonlight.LOGGER.info("Wrote cached resource pack to {} in {}", (Object)this.path, (Object)stopwatch);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZipPreferStored(Map<ResourceLocation, byte[]> files, Path outputZip) throws IOException {
        Path parent = outputZip.getParent();
        if (parent == null) {
            parent = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        } else {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Path tmp = Files.createTempFile(parent, "dynpack-", ".zip", new FileAttribute[0]);
        boolean moved = false;
        try {
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmp, StandardOpenOption.TRUNCATE_EXISTING));
                 ZipOutputStream zos = new ZipOutputStream(os);){
                this.writeEntriesStored(zos, files);
            }
            this.moveIntoPlace(tmp, outputZip);
            moved = true;
        }
        catch (Exception storedEx) {
            Moonlight.LOGGER.warn("Could not write zip using STORED; falling back to DEFLATED: {}", (Object)String.valueOf(storedEx));
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmp, StandardOpenOption.TRUNCATE_EXISTING));
                 ZipOutputStream zos = new ZipOutputStream(os);){
                this.writeEntriesDeflated(zos, files, 0);
            }
            this.moveIntoPlace(tmp, outputZip);
            moved = true;
        }
        finally {
            if (!moved) {
                try {
                    Files.deleteIfExists(tmp);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void moveIntoPlace(Path tmp, Path target) throws IOException {
        try {
            Files.move(tmp, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException ex) {
            Files.move(tmp, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void writeEntriesStored(ZipOutputStream zos, Map<ResourceLocation, byte[]> files) throws IOException {
        for (Map.Entry<ResourceLocation, byte[]> e : files.entrySet()) {
            String name = this.packType.getDirectory() + "/" + e.getKey().toString().replace(':', '/').replace('\\', '/');
            byte[] data = e.getValue();
            CRC32 crc = new CRC32();
            crc.update(data);
            ZipEntry ze = new ZipEntry(name);
            ze.setMethod(0);
            ze.setSize(data.length);
            ze.setCompressedSize(data.length);
            ze.setCrc(crc.getValue());
            zos.putNextEntry(ze);
            zos.write(data);
            zos.closeEntry();
        }
    }

    private void writeEntriesDeflated(ZipOutputStream zos, Map<ResourceLocation, byte[]> files, int level) throws IOException {
        zos.setLevel(level);
        for (Map.Entry<ResourceLocation, byte[]> e : files.entrySet()) {
            String name = this.packType.getDirectory() + "/" + e.getKey().toString().replace(':', '/').replace('\\', '/');
            ZipEntry ze = new ZipEntry(name);
            zos.putNextEntry(ze);
            zos.write(e.getValue());
            zos.closeEntry();
        }
    }
}

