/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutState {
    public static final long BASE_TIMEOUT = TimeUnit.SECONDS.toNanos(30L);
    public static final long TIMEOUT = TimeUnit.MILLISECONDS.toNanos(7000L);
    public static final long ABORT_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(1500L);
    public static final String ABORT_MESSAGE = "Too long without yielding";
    @GuardedBy(value="this")
    private final List<Runnable> listeners = new ArrayList<Runnable>(0);
    protected boolean paused;
    protected boolean softAbort;
    protected volatile boolean hardAbort;

    public abstract void refresh();

    public final boolean isPaused() {
        return this.paused;
    }

    public final boolean isSoftAborted() {
        return this.softAbort;
    }

    public final boolean isHardAborted() {
        return this.hardAbort;
    }

    @GuardedBy(value="this")
    protected final void updateListeners() {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }

    public final synchronized void addListener(Runnable listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        this.listeners.add(listener);
        listener.run();
    }

    public final synchronized void removeListener(Runnable listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        this.listeners.remove(listener);
    }
}

