/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer.mainthread;

import dan200.computercraft.core.computer.mainthread.MainThread;
import dan200.computercraft.core.computer.mainthread.MainThreadScheduler;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.core.metrics.MetricsObserver;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class MainThreadExecutor
implements MainThreadScheduler.Executor {
    private static final int MAX_TASKS = 5000;
    private final MetricsObserver metrics;
    private final Object queueLock = new Object();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(4);
    volatile boolean onQueue;
    private long budget = 0L;
    private int currentTick = -1;
    private State state = State.COOL;
    private long pendingTime;
    long virtualTime;
    private final MainThread scheduler;

    MainThreadExecutor(MetricsObserver metrics, MainThread scheduler) {
        this.metrics = metrics;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.tasks.size() >= 5000 || !this.tasks.offer(runnable)) {
                return false;
            }
            if (!this.onQueue && this.state == State.COOL) {
                this.scheduler.queue(this);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        Runnable task;
        if (this.state != State.COOL) {
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            task = this.tasks.poll();
        }
        if (task != null) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean afterExecute(long time) {
        this.consumeTime(time);
        Object object = this.queueLock;
        synchronized (object) {
            this.virtualTime += time;
            this.updateTime();
            if (this.state != State.COOL || this.tasks.isEmpty()) {
                this.onQueue = false;
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean canWork() {
        return this.state != State.COOLING && this.scheduler.canExecute();
    }

    @Override
    public boolean shouldWork() {
        return this.state == State.COOL && this.scheduler.canExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackWork(long time, TimeUnit unit) {
        long nanoTime = unit.toNanos(time);
        Object object = this.queueLock;
        synchronized (object) {
            this.pendingTime += nanoTime;
        }
        this.consumeTime(nanoTime);
        this.scheduler.consumeTime(nanoTime);
    }

    private void consumeTime(long time) {
        this.metrics.observe(Metrics.SERVER_TASKS, time);
        if (this.currentTick != this.scheduler.currentTick()) {
            this.currentTick = this.scheduler.currentTick();
            this.budget = this.scheduler.config.maxComputerTime();
        }
        this.budget -= time;
        if (this.budget < 0L && this.state == State.COOL) {
            this.state = State.HOT;
            this.scheduler.cooling(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tickCooling() {
        this.state = State.COOLING;
        this.currentTick = this.scheduler.currentTick();
        long maxTime = this.scheduler.config.maxComputerTime();
        this.budget = Math.min(this.budget + maxTime, maxTime);
        if (this.budget < maxTime) {
            return false;
        }
        this.state = State.COOL;
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.tasks.isEmpty() && !this.onQueue) {
                this.scheduler.queue(this);
            }
        }
        return true;
    }

    void updateTime() {
        this.virtualTime += this.pendingTime;
        this.pendingTime = 0L;
    }

    private static enum State {
        COOL,
        HOT,
        COOLING;

    }
}

