/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.VarargArguments;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaValue;

class TableImpl
implements LuaTable<Object, Object> {
    private final VarargArguments arguments;
    private final org.squiddev.cobalt.LuaTable table;
    private @Nullable Map<Object, Object> backingMap;

    TableImpl(VarargArguments arguments, org.squiddev.cobalt.LuaTable table) {
        this.arguments = arguments;
        this.table = table;
    }

    @Override
    public int size() {
        this.checkValid();
        return this.table.size();
    }

    @Override
    public int length() {
        return this.table.length();
    }

    @Override
    public long getLong(int index) throws LuaException {
        LuaValue value = this.table.rawget(index);
        if (!(value instanceof LuaNumber)) {
            throw LuaValues.badTableItem(index, "number", value.typeName());
        }
        if (value instanceof LuaInteger) {
            return value.toInteger();
        }
        double number = value.toDouble();
        if (!Double.isFinite(number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getNumericType(number));
        }
        return (long)number;
    }

    @Override
    public boolean isEmpty() {
        this.checkValid();
        try {
            return this.table.next(Constants.NIL).first().isNil();
        }
        catch (LuaError e) {
            throw new IllegalStateException(e);
        }
    }

    private LuaValue getImpl(Object o) {
        this.checkValid();
        if (o instanceof String) {
            String s = (String)o;
            return this.table.rawget(s);
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return this.table.rawget(i.intValue());
        }
        return Constants.NIL;
    }

    @Override
    public boolean containsKey(Object o) {
        return !this.getImpl(o).isNil();
    }

    @Override
    public @Nullable Object get(Object o) {
        return CobaltLuaMachine.toObject(this.getImpl(o), null);
    }

    private Map<Object, Object> getBackingMap() {
        this.checkValid();
        if (this.backingMap != null) {
            return this.backingMap;
        }
        this.backingMap = Collections.unmodifiableMap(Objects.requireNonNull((Map)CobaltLuaMachine.toObject((LuaValue)this.table, null)));
        return this.backingMap;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getBackingMap().containsKey(o);
    }

    @Override
    public Set<Object> keySet() {
        return this.getBackingMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.getBackingMap().values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.getBackingMap().entrySet();
    }

    private void checkValid() {
        if (this.arguments.isClosed()) {
            throw new IllegalStateException("Cannot use LuaTable after IArguments has been released");
        }
    }
}

