/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongFunction;

public abstract class Metric {
    private static final Map<String, Metric> allMetrics = new ConcurrentHashMap<String, Metric>();
    private static final AtomicInteger nextId = new AtomicInteger();
    private final int id;
    private final String name;
    private final String unit;
    private final LongFunction<String> format;
    private static final int KILOBYTE_SIZE = 1024;
    private static final String SI_PREFIXES = "KMGT";

    private Metric(String name, String unit, LongFunction<String> format) {
        if (allMetrics.containsKey(name)) {
            throw new IllegalStateException("Duplicate key " + name);
        }
        this.id = nextId.getAndIncrement();
        this.name = name;
        this.unit = unit;
        this.format = format;
        allMetrics.put(name, this);
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String unit() {
        return this.unit;
    }

    public String format(long value) {
        return this.format.apply(value);
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.name();
    }

    public static Map<String, Metric> metrics() {
        return Collections.unmodifiableMap(allMetrics);
    }

    public static String formatTime(long value) {
        return String.format("%.1fms", (double)value * 1.0E-6);
    }

    public static String formatDefault(long value) {
        return String.format("%d", value);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return String.format("%d B", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        if (exp > SI_PREFIXES.length()) {
            exp = SI_PREFIXES.length();
        }
        return String.format("%.1f %siB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf(SI_PREFIXES.charAt(exp - 1)));
    }

    public static final class Event
    extends Metric {
        public Event(String id, String unit, LongFunction<String> format) {
            super(id, unit, format);
        }
    }

    public static final class Counter
    extends Metric {
        public Counter(String id) {
            super(id, "", Metric::formatDefault);
        }
    }
}

