/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.mixin;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.util.datafix.schemas.V1460;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={V1460.class})
class V1460Mixin {
    V1460Mixin() {
    }

    @Inject(at={@At(value="RETURN")}, method={"registerBlockEntities"})
    private void registerBlockEntities(Schema schema, CallbackInfoReturnable<Map<String, Supplier<TypeTemplate>>> ci) {
        Map map = (Map)ci.getReturnValue();
        V1460Mixin.registerTurtle(schema, map, "computercraft:turtle_normal");
        V1460Mixin.registerTurtle(schema, map, "computercraft:turtle_advanced");
        V1460Mixin.registerInventory(schema, map, "computercraft:printer");
        schema.register(map, "computercraft:disk_drive", () -> DSL.optionalFields((String)"Item", (TypeTemplate)References.ITEM_STACK.in(schema)));
    }

    private static TypeTemplate upgradeData(Schema schema) {
        return DSL.or((TypeTemplate)DSL.constType((Type)NamespacedSchema.namespacedString()), (TypeTemplate)DSL.optionalFields((String)"components", (TypeTemplate)References.DATA_COMPONENTS.in(schema)));
    }

    @Unique
    private static void registerTurtle(Schema schema, Map<String, Supplier<TypeTemplate>> map, String name) {
        schema.register(map, name, () -> DSL.optionalFields((String)"LeftUpgrade", (TypeTemplate)V1460Mixin.upgradeData(schema), (String)"RightUpgrade", (TypeTemplate)V1460Mixin.upgradeData(schema), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema))));
    }

    @Shadow
    protected static void registerInventory(Schema schema, Map<String, Supplier<TypeTemplate>> map, String name) {
    }
}

