/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.config.Config;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public enum ComputerFamily {
    NORMAL,
    ADVANCED,
    COMMAND;


    public boolean checkUsable(Player player) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> true;
            case 2 -> ComputerFamily.checkCommandUsable(player);
        };
    }

    private static boolean checkCommandUsable(Player player) {
        MinecraftServer server = player.getServer();
        if (server == null || !server.isCommandBlockEnabled()) {
            player.displayClientMessage((Component)Component.translatable((String)"advMode.notEnabled"), true);
            return false;
        }
        if (!ComputerFamily.canUseCommandBlock(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"advMode.notAllowed"), true);
            return false;
        }
        return true;
    }

    private static boolean canUseCommandBlock(Player player) {
        return Config.commandRequireCreative ? player.canUseGameMasterBlocks() : player.hasPermissions(2);
    }
}

