/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.config;

import dan200.computercraft.core.CoreConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

record ProxyPasswordConfig(String username, String password) {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyPasswordConfig.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable ProxyPasswordConfig loadFromFile(@Nullable Path path) {
        if (path == null) return null;
        if (!path.toFile().exists()) {
            return null;
        }
        try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String line = br.readLine();
            if (line == null) {
                ProxyPasswordConfig proxyPasswordConfig = null;
                return proxyPasswordConfig;
            }
            String[] parts = line.trim().split(":", 2);
            if (parts.length == 0) {
                ProxyPasswordConfig proxyPasswordConfig = null;
                return proxyPasswordConfig;
            }
            ProxyPasswordConfig proxyPasswordConfig = new ProxyPasswordConfig(parts[0], parts.length == 2 ? parts[1] : "");
            return proxyPasswordConfig;
        }
        catch (IOException e) {
            LOG.error("Failed to load proxy password from {}.", (Object)path, (Object)e);
            return null;
        }
    }

    static void init(@Nullable Path path) {
        ProxyPasswordConfig config = ProxyPasswordConfig.loadFromFile(path);
        if (config == null) {
            CoreConfig.httpProxyUsername = "";
            CoreConfig.httpProxyPassword = "";
        } else {
            CoreConfig.httpProxyUsername = config.username;
            CoreConfig.httpProxyPassword = config.password;
        }
    }
}

