/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import com.google.auto.service.AutoService;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.integration.PermissionRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionType;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;

public final class ForgePermissionRegistry
extends PermissionRegistry {
    private final List<PermissionNode<?>> nodes = new ArrayList();

    private ForgePermissionRegistry() {
    }

    private <T> PermissionNode<T> registerNode(String nodeName, PermissionType<T> type, PermissionNode.PermissionResolver<T> defaultResolver) {
        this.checkNotFrozen();
        PermissionNode node = new PermissionNode("computercraft", nodeName, type, defaultResolver, new PermissionDynamicContextKey[0]);
        this.nodes.add(node);
        return node;
    }

    @Override
    public Predicate<CommandSourceStack> registerCommand(String command, UserLevel fallback) {
        PermissionNode node = this.registerNode("command." + command, PermissionTypes.BOOLEAN, (player, uuid, context) -> player != null && fallback.test(player));
        return source -> {
            ServerPlayer player = source.getPlayer();
            return player == null ? fallback.test((CommandSourceStack)source) : ((Boolean)PermissionAPI.getPermission((ServerPlayer)player, (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue();
        };
    }

    @Override
    public void register() {
        super.register();
        NeoForge.EVENT_BUS.addListener(event -> event.addNodes(this.nodes));
    }

    @AutoService(value={PermissionRegistry.Provider.class})
    public static final class Provider
    implements PermissionRegistry.Provider {
        @Override
        public Optional<PermissionRegistry> get() {
            return Optional.of(new ForgePermissionRegistry());
        }
    }
}

