/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.recipes;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class PocketComputerUpgradeRecipe
extends CustomRecipe {
    public PocketComputerUpgradeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x >= 2 && y >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack((ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get());
    }

    public boolean matches(CraftingInput inventory, Level world) {
        return !this.assemble(inventory, (HolderLookup.Provider)world.registryAccess()).isEmpty();
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider registryAccess) {
        ItemStack computer = ItemStack.EMPTY;
        int computerX = -1;
        int computerY = -1;
        block0: for (int y = 0; y < inventory.height(); ++y) {
            for (int x = 0; x < inventory.width(); ++x) {
                ItemStack item = inventory.getItem(x, y);
                if (item.isEmpty() || !(item.getItem() instanceof PocketComputerItem)) continue;
                computer = item;
                computerX = x;
                computerY = y;
                break block0;
            }
        }
        if (computer.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (PocketComputerItem.getUpgradeWithData(computer) != null) {
            return ItemStack.EMPTY;
        }
        UpgradeData<IPocketUpgrade> upgrade = null;
        for (int y = 0; y < inventory.height(); ++y) {
            for (int x = 0; x < inventory.width(); ++x) {
                ItemStack item = inventory.getItem(x, y);
                if (x == computerX && y == computerY || !(x == computerX && y == computerY - 1 ? (upgrade = PocketUpgrades.instance().get(registryAccess, item)) == null : !item.isEmpty())) continue;
                return ItemStack.EMPTY;
            }
        }
        if (upgrade == null) {
            return ItemStack.EMPTY;
        }
        ItemStack result = computer.copyWithCount(1);
        result.set((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), upgrade);
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.POCKET_COMPUTER_UPGRADE.get();
    }
}

