/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import dan200.computercraft.shared.recipe.BasicRecipeSerialiser;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public abstract class CustomShapelessRecipe
extends ShapelessRecipe {
    private final ItemStack result;
    private final boolean showNotification;

    protected CustomShapelessRecipe(ShapelessRecipeSpec recipe) {
        super(recipe.properties().group(), recipe.properties().category(), recipe.result(), recipe.ingredients());
        this.result = recipe.result();
        this.showNotification = recipe.properties().showNotification();
    }

    public final ShapelessRecipeSpec toSpec() {
        return new ShapelessRecipeSpec(RecipeProperties.of((CraftingRecipe)this), (NonNullList<Ingredient>)this.getIngredients(), this.result);
    }

    public final boolean showNotification() {
        return this.showNotification;
    }

    public abstract RecipeSerializer<? extends CustomShapelessRecipe> getSerializer();

    public static <T extends CustomShapelessRecipe> RecipeSerializer<T> serialiser(Function<ShapelessRecipeSpec, T> factory) {
        return new BasicRecipeSerialiser(ShapelessRecipeSpec.CODEC.xmap(factory, CustomShapelessRecipe::toSpec), ShapelessRecipeSpec.STREAM_CODEC.map(factory, CustomShapelessRecipe::toSpec));
    }
}

