/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Math;
import org.lwjgl.system.MemoryUtil;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.mixin.access.NativeImageAccessor;

public class TextureUtil {
    private static int highestAlpha;

    public static void boostAlpha(NativeImage img, String debugName) {
        highestAlpha = 0;
        TextureUtil.applyToAllPixels(img, rgba -> {
            Color col = new Color(rgba, true);
            highestAlpha = Math.max((int)col.getAlpha(), (int)highestAlpha);
            return rgba;
        });
        if (highestAlpha == 255 || highestAlpha == 0) {
            return;
        }
        int multiplier = 255 / highestAlpha;
        if (multiplier == 1) {
            return;
        }
        ParticleRain.LOGGER.info("Multiplying {} texture alpha by {}", (Object)debugName, (Object)multiplier);
        TextureUtil.applyToAllPixels(img, rgba -> {
            Color col = new Color(rgba, true);
            return (col.getAlpha() * multiplier & 0xFF) << 24 | (col.getRed() & 0xFF) << 16 | (col.getGreen() & 0xFF) << 8 | col.getBlue() & 0xFF;
        });
    }

    public static void desaturate(NativeImage img) {
        TextureUtil.applyToAllPixels(img, rgba -> {
            Color col = new Color(rgba, true);
            int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
            return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
        });
    }

    public static void applyToAllPixels(NativeImage image, IntUnaryOperator function) {
        if (image.format() != NativeImage.Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", image.format()));
        }
        ((NativeImageAccessor)image).callCheckAllocated();
        int i = image.getWidth() * image.getHeight();
        IntBuffer intBuffer = MemoryUtil.memIntBuffer((long)((NativeImageAccessor)image).getPixels(), (int)i);
        for (int j = 0; j < i; ++j) {
            int k = TextureUtil.argbToABGR(intBuffer.get(j));
            int l = function.applyAsInt(k);
            intBuffer.put(j, TextureUtil.argbToABGR(l));
        }
    }

    public static int argbToABGR(int i) {
        return i & 0xFF00FF00 | (i & 0xFF0000) >> 16 | (i & 0xFF) << 16;
    }

    public static void applyWaterTint(SingleQuadParticle particle, ClientLevel level, BlockPos blockPos) {
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            if (!opts.getClass().equals(ConfigData.ParticleData.class) || !opts.id.equals("rain")) continue;
            opts.tintType.applyTint(particle, level, blockPos, opts);
        }
    }

    public static NativeImage loadTexture(ResourceLocation location) throws IOException {
        return TextureUtil.loadTexture(Minecraft.getInstance().getResourceManager().getResourceOrThrow(location));
    }

    public static NativeImage loadTexture(Resource resource) throws IOException {
        NativeImage nativeImage;
        try (InputStream inputStream = resource.open();){
            nativeImage = NativeImage.read((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static SpriteContents splitImage(NativeImage image, int segment, String id) {
        int size = image.getWidth();
        NativeImage sprite = new NativeImage(size, size, false);
        image.copyRect(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return VersionUtil.newNonAnimatedSpriteContents(id + segment, new FrameSize(size, size), sprite);
    }

    public static int getRippleResolution(List<SpriteContents> contents) {
        if (ConfigManager.config.ripple.useResourcepackResolution) {
            ResourceLocation resourceLocation = VersionUtil.getMcId("big_smoke_0");
            for (SpriteContents spriteContents : contents) {
                if (!spriteContents.name().equals((Object)resourceLocation)) continue;
                if (spriteContents.width() < 256) {
                    return spriteContents.width();
                }
                return 256;
            }
        }
        if (ConfigManager.config.ripple.resolution < 4) {
            ConfigManager.config.ripple.resolution = 4;
        }
        if (ConfigManager.config.ripple.resolution > 256) {
            ConfigManager.config.ripple.resolution = 256;
        }
        return ConfigManager.config.ripple.resolution;
    }

    public static SpriteContents generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        NativeImage image = new NativeImage(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        TextureUtil.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return VersionUtil.newNonAnimatedSpriteContents("ripple_" + i, new FrameSize(size, size), image);
    }

    public static void generateBresenhamCircle(NativeImage image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        TextureUtil.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            TextureUtil.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    static void drawCirclePixel(int xc, int yc, int x, int y, NativeImage img, int col) {
        img.setPixelRGBA(xc + x, yc + y, col);
        img.setPixelRGBA(xc - x, yc + y, col);
        img.setPixelRGBA(xc + x, yc - y, col);
        img.setPixelRGBA(xc - x, yc - y, col);
        img.setPixelRGBA(xc + y, yc + x, col);
        img.setPixelRGBA(xc - y, yc + x, col);
        img.setPixelRGBA(xc + y, yc - x, col);
        img.setPixelRGBA(xc - y, yc - x, col);
    }
}

