/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;

public class VersionUtil {
    public static ResourceLocation getId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"particlerain", (String)path);
    }

    public static ResourceLocation getMcId(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation parseId(String string) {
        try {
            return ResourceLocation.parse((String)string);
        }
        catch (ResourceLocationException e) {
            return null;
        }
    }

    public static ClipContext getClipContext(Vec3 clipStart, Vec3 clipEnd) {
        return new ClipContext(clipStart, clipEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, CollisionContext.empty());
    }

    public static ResourceMetadata getEmptySpriteMetadata() {
        return new ResourceMetadata.Builder().build();
    }

    public static SpriteContents loadSplashSprite(int i) throws IOException {
        ResourceLocation location = VersionUtil.getMcId("textures/particle/splash_" + i + ".png");
        Resource resource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(location);
        ResourceMetadata resourceMetadata = resource.metadata();
        NativeImage splashImage = TextureUtil.loadTexture(resource);
        TextureUtil.desaturate(splashImage);
        Optional animationMetadata = resourceMetadata.getSection((MetadataSectionSerializer)AnimationMetadataSection.SERIALIZER);
        FrameSize frameSize = animationMetadata.isPresent() ? ((AnimationMetadataSection)animationMetadata.get()).calculateFrameSize(splashImage.getWidth(), splashImage.getHeight()) : new FrameSize(splashImage.getWidth(), splashImage.getHeight());
        return new SpriteContents(VersionUtil.getId("splash_" + i), frameSize, splashImage, resourceMetadata);
    }

    public static Biome.Precipitation getPrecipitationAt(Level level, Holder<Biome> biome, BlockPos blockPos) {
        return ((Biome)biome.value()).getPrecipitationAt(blockPos);
    }

    public static Color getMapColor(ClientLevel level, BlockPos blockPos) {
        Color color = new Color(level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).below()).getBlock().defaultMapColor().calculateRGBColor(MapColor.Brightness.NORMAL));
        return new Color(color.getBlue(), color.getGreen(), color.getRed());
    }

    public static void schedule(Runnable task) {
        Minecraft.getInstance().tell(task);
    }

    public static <T> Stream<TagKey<T>> getTagIds(Registry<T> registry) {
        return registry.getTagNames();
    }

    public static <T> Registry<T> getRegistry(ResourceKey<Registry<T>> key) {
        return Minecraft.getInstance().level.registryAccess().registryOrThrow(key);
    }

    public static int getCloudHeight(ClientLevel level) {
        return (int)level.effects().getCloudHeight();
    }

    public static TextureAtlasSprite getSprite(ResourceLocation id) {
        return ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getTextureAtlas().getSprite(id);
    }

    public static SpriteContents newNonAnimatedSpriteContents(String id, FrameSize frameSize, NativeImage sprite) {
        return new SpriteContents(VersionUtil.getId(id), frameSize, sprite, VersionUtil.getEmptySpriteMetadata());
    }
}

