/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.jankson;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import io.github.cottonmc.jankson.BlockAndItemSerializers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;

public class JanksonFactory {
    public static Jankson.Builder builder() {
        Jankson.Builder builder = Jankson.builder();
        builder.registerDeserializer(String.class, ItemStack.class, BlockAndItemSerializers::getItemStackPrimitive).registerDeserializer(JsonObject.class, ItemStack.class, BlockAndItemSerializers::getItemStack).registerSerializer(ItemStack.class, BlockAndItemSerializers::saveItemStack);
        builder.registerDeserializer(String.class, BlockState.class, BlockAndItemSerializers::getBlockStatePrimitive).registerDeserializer(JsonObject.class, BlockState.class, BlockAndItemSerializers::getBlockState).registerSerializer(BlockState.class, BlockAndItemSerializers::saveBlockState);
        builder.registerDeserializer(String.class, ResourceLocation.class, (s, m) -> ResourceLocation.parse((String)s)).registerSerializer(ResourceLocation.class, (i, m) -> new JsonPrimitive((Object)i.toString()));
        JanksonFactory.register(builder, Activity.class, BuiltInRegistries.ACTIVITY);
        JanksonFactory.register(builder, ArgumentTypeInfo.class, BuiltInRegistries.COMMAND_ARGUMENT_TYPE);
        JanksonFactory.register(builder, ArmorMaterial.class, BuiltInRegistries.ARMOR_MATERIAL);
        JanksonFactory.register(builder, Block.class, BuiltInRegistries.BLOCK);
        JanksonFactory.register(builder, BlockEntityType.class, BuiltInRegistries.BLOCK_ENTITY_TYPE);
        JanksonFactory.register(builder, BlockPredicateType.class, BuiltInRegistries.BLOCK_PREDICATE_TYPE);
        JanksonFactory.register(builder, BlockStateProviderType.class, BuiltInRegistries.BLOCKSTATE_PROVIDER_TYPE);
        JanksonFactory.register(builder, WorldCarver.class, BuiltInRegistries.CARVER);
        JanksonFactory.register(builder, CatVariant.class, BuiltInRegistries.CAT_VARIANT);
        JanksonFactory.register(builder, ChunkStatus.class, BuiltInRegistries.CHUNK_STATUS);
        JanksonFactory.register(builder, CriterionTrigger.class, BuiltInRegistries.TRIGGER_TYPES);
        JanksonFactory.register(builder, Attribute.class, BuiltInRegistries.ATTRIBUTE);
        JanksonFactory.register(builder, EntityType.class, BuiltInRegistries.ENTITY_TYPE);
        JanksonFactory.register(builder, Feature.class, BuiltInRegistries.FEATURE);
        JanksonFactory.register(builder, FeatureSizeType.class, BuiltInRegistries.FEATURE_SIZE_TYPE);
        JanksonFactory.register(builder, FloatProviderType.class, BuiltInRegistries.FLOAT_PROVIDER_TYPE);
        JanksonFactory.register(builder, Fluid.class, BuiltInRegistries.FLUID);
        JanksonFactory.register(builder, FoliagePlacerType.class, BuiltInRegistries.FOLIAGE_PLACER_TYPE);
        JanksonFactory.register(builder, FrogVariant.class, BuiltInRegistries.FROG_VARIANT);
        JanksonFactory.register(builder, GameEvent.class, BuiltInRegistries.GAME_EVENT);
        JanksonFactory.register(builder, HeightProviderType.class, BuiltInRegistries.HEIGHT_PROVIDER_TYPE);
        JanksonFactory.register(builder, Instrument.class, BuiltInRegistries.INSTRUMENT);
        JanksonFactory.register(builder, IntProviderType.class, BuiltInRegistries.INT_PROVIDER_TYPE);
        JanksonFactory.register(builder, Item.class, BuiltInRegistries.ITEM);
        JanksonFactory.register(builder, CreativeModeTab.class, BuiltInRegistries.CREATIVE_MODE_TAB);
        JanksonFactory.register(builder, ItemSubPredicate.Type.class, BuiltInRegistries.ITEM_SUB_PREDICATE_TYPE);
        JanksonFactory.register(builder, LootItemConditionType.class, BuiltInRegistries.LOOT_CONDITION_TYPE);
        JanksonFactory.register(builder, LootItemFunctionType.class, BuiltInRegistries.LOOT_FUNCTION_TYPE);
        JanksonFactory.register(builder, LootNbtProviderType.class, BuiltInRegistries.LOOT_NBT_PROVIDER_TYPE);
        JanksonFactory.register(builder, LootNumberProviderType.class, BuiltInRegistries.LOOT_NUMBER_PROVIDER_TYPE);
        JanksonFactory.register(builder, LootPoolEntryType.class, BuiltInRegistries.LOOT_POOL_ENTRY_TYPE);
        JanksonFactory.register(builder, LootScoreProviderType.class, BuiltInRegistries.LOOT_SCORE_PROVIDER_TYPE);
        JanksonFactory.register(builder, MapDecorationType.class, BuiltInRegistries.MAP_DECORATION_TYPE);
        JanksonFactory.register(builder, MemoryModuleType.class, BuiltInRegistries.MEMORY_MODULE_TYPE);
        JanksonFactory.register(builder, NumberFormatType.class, BuiltInRegistries.NUMBER_FORMAT_TYPE);
        JanksonFactory.register(builder, ParticleType.class, BuiltInRegistries.PARTICLE_TYPE);
        JanksonFactory.register(builder, PlacementModifierType.class, BuiltInRegistries.PLACEMENT_MODIFIER_TYPE);
        JanksonFactory.register(builder, PoiType.class, BuiltInRegistries.POINT_OF_INTEREST_TYPE);
        JanksonFactory.register(builder, PositionSourceType.class, BuiltInRegistries.POSITION_SOURCE_TYPE);
        JanksonFactory.register(builder, PosRuleTestType.class, BuiltInRegistries.POS_RULE_TEST);
        JanksonFactory.register(builder, Potion.class, BuiltInRegistries.POTION);
        JanksonFactory.register(builder, RecipeSerializer.class, BuiltInRegistries.RECIPE_SERIALIZER);
        JanksonFactory.register(builder, RecipeType.class, BuiltInRegistries.RECIPE_TYPE);
        JanksonFactory.register(builder, RootPlacerType.class, BuiltInRegistries.ROOT_PLACER_TYPE);
        JanksonFactory.register(builder, RuleBlockEntityModifierType.class, BuiltInRegistries.RULE_BLOCK_ENTITY_MODIFIER);
        JanksonFactory.register(builder, RuleTestType.class, BuiltInRegistries.RULE_TEST);
        JanksonFactory.register(builder, Schedule.class, BuiltInRegistries.SCHEDULE);
        JanksonFactory.register(builder, MenuType.class, BuiltInRegistries.MENU);
        JanksonFactory.register(builder, SensorType.class, BuiltInRegistries.SENSOR_TYPE);
        JanksonFactory.register(builder, SoundEvent.class, BuiltInRegistries.SOUND_EVENT);
        JanksonFactory.register(builder, StatType.class, BuiltInRegistries.STAT_TYPE);
        JanksonFactory.register(builder, MobEffect.class, BuiltInRegistries.MOB_EFFECT);
        JanksonFactory.register(builder, StructurePlacementType.class, BuiltInRegistries.STRUCTURE_PLACEMENT);
        JanksonFactory.register(builder, StructurePieceType.class, BuiltInRegistries.STRUCTURE_PIECE);
        JanksonFactory.register(builder, StructurePoolElementType.class, BuiltInRegistries.STRUCTURE_POOL_ELEMENT);
        JanksonFactory.register(builder, StructureProcessorType.class, BuiltInRegistries.STRUCTURE_PROCESSOR);
        JanksonFactory.register(builder, StructureType.class, BuiltInRegistries.STRUCTURE_TYPE);
        JanksonFactory.register(builder, TreeDecoratorType.class, BuiltInRegistries.TREE_DECORATOR_TYPE);
        JanksonFactory.register(builder, TrunkPlacerType.class, BuiltInRegistries.TRUNK_PLACER_TYPE);
        JanksonFactory.register(builder, VillagerProfession.class, BuiltInRegistries.VILLAGER_PROFESSION);
        JanksonFactory.register(builder, VillagerType.class, BuiltInRegistries.VILLAGER_TYPE);
        JanksonFactory.register(builder, Registry.class, BuiltInRegistries.REGISTRY);
        return builder;
    }

    private static <T> void register(Jankson.Builder builder, Class<T> clazz, Registry<? extends T> registry) {
        builder.registerDeserializer(String.class, clazz, (s, m) -> JanksonFactory.lookupDeserialize(s, registry));
        builder.registerSerializer(clazz, (o, m) -> JanksonFactory.lookupSerialize(o, registry));
    }

    private static <T> T lookupDeserialize(String s, Registry<T> registry) {
        return (T)registry.get(ResourceLocation.parse((String)s));
    }

    private static <T, U extends T> JsonElement lookupSerialize(T t, Registry<U> registry) {
        ResourceLocation id = registry.getKey(t);
        if (id == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Object)id.toString());
    }

    public static Jankson createJankson() {
        return JanksonFactory.builder().build();
    }
}

