/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.synonym.word2vec;

import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefHash;
import guideme.internal.shaded.lucene.util.TermAndVector;
import java.io.IOException;

public class Word2VecModel
extends FloatVectorValues {
    private final int dictionarySize;
    private final int vectorDimension;
    private final TermAndVector[] termsAndVectors;
    private final BytesRefHash word2Vec;
    private int loadedCount = 0;

    public Word2VecModel(int dictionarySize, int vectorDimension) {
        this.dictionarySize = dictionarySize;
        this.vectorDimension = vectorDimension;
        this.termsAndVectors = new TermAndVector[dictionarySize];
        this.word2Vec = new BytesRefHash();
    }

    private Word2VecModel(int dictionarySize, int vectorDimension, TermAndVector[] termsAndVectors, BytesRefHash word2Vec) {
        this.dictionarySize = dictionarySize;
        this.vectorDimension = vectorDimension;
        this.termsAndVectors = termsAndVectors;
        this.word2Vec = word2Vec;
    }

    public void addTermAndVector(TermAndVector modelEntry) {
        modelEntry = modelEntry.normalizeVector();
        this.termsAndVectors[this.loadedCount++] = modelEntry;
        this.word2Vec.add(modelEntry.term());
    }

    @Override
    public float[] vectorValue(int targetOrd) {
        return this.termsAndVectors[targetOrd].vector();
    }

    public float[] vectorValue(BytesRef term) {
        int termOrd = this.word2Vec.find(term);
        if (termOrd < 0) {
            return null;
        }
        TermAndVector entry = this.termsAndVectors[termOrd];
        return entry == null ? null : entry.vector();
    }

    public BytesRef termValue(int targetOrd) {
        return this.termsAndVectors[targetOrd].term();
    }

    @Override
    public int dimension() {
        return this.vectorDimension;
    }

    @Override
    public int size() {
        return this.dictionarySize;
    }

    @Override
    public Word2VecModel copy() throws IOException {
        return new Word2VecModel(this.dictionarySize, this.vectorDimension, this.termsAndVectors, this.word2Vec);
    }
}

