/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValuesSkipper;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.SegmentCommitInfo;
import guideme.internal.shaded.lucene.index.SegmentDocValues;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.internal.hppc.IntObjectHashMap;
import guideme.internal.shaded.lucene.internal.hppc.LongArrayList;
import guideme.internal.shaded.lucene.store.Directory;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

class SegmentDocValuesProducer
extends DocValuesProducer {
    final IntObjectHashMap<DocValuesProducer> dvProducersByField = new IntObjectHashMap();
    final Set<DocValuesProducer> dvProducers = Collections.newSetFromMap(new IdentityHashMap());
    final LongArrayList dvGens = new LongArrayList();

    SegmentDocValuesProducer(SegmentCommitInfo si, Directory dir, FieldInfos coreInfos, FieldInfos allInfos, SegmentDocValues segDocValues) throws IOException {
        try {
            DocValuesProducer baseProducer = null;
            for (FieldInfo fi : allInfos) {
                if (fi.getDocValuesType() == DocValuesType.NONE) continue;
                long docValuesGen = fi.getDocValuesGen();
                if (docValuesGen == -1L) {
                    if (baseProducer == null) {
                        baseProducer = segDocValues.getDocValuesProducer(docValuesGen, si, dir, coreInfos);
                        this.dvGens.add(docValuesGen);
                        this.dvProducers.add(baseProducer);
                    }
                    this.dvProducersByField.put(fi.number, baseProducer);
                    continue;
                }
                assert (!this.dvGens.contains(docValuesGen));
                DocValuesProducer dvp = segDocValues.getDocValuesProducer(docValuesGen, si, dir, new FieldInfos(new FieldInfo[]{fi}));
                this.dvGens.add(docValuesGen);
                this.dvProducers.add(dvp);
                this.dvProducersByField.put(fi.number, dvp);
            }
        }
        catch (Throwable t) {
            try {
                segDocValues.decRef(this.dvGens);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.number);
        assert (dvProducer != null);
        return dvProducer.getNumeric(field);
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.number);
        assert (dvProducer != null);
        return dvProducer.getBinary(field);
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.number);
        assert (dvProducer != null);
        return dvProducer.getSorted(field);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.number);
        assert (dvProducer != null);
        return dvProducer.getSortedNumeric(field);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.number);
        assert (dvProducer != null);
        return dvProducer.getSortedSet(field);
    }

    @Override
    public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
        DocValuesProducer dvProducer = this.dvProducersByField.get(field.number);
        assert (dvProducer != null);
        return dvProducer.getSkipper(field);
    }

    @Override
    public void checkIntegrity() throws IOException {
        for (DocValuesProducer producer : this.dvProducers) {
            producer.checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

