/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.knn;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.TopKnnCollector;
import guideme.internal.shaded.lucene.search.knn.KnnCollectorManager;
import guideme.internal.shaded.lucene.search.knn.MultiLeafKnnCollector;
import guideme.internal.shaded.lucene.util.hnsw.BlockingFloatHeap;
import java.io.IOException;

public class TopKnnCollectorManager
implements KnnCollectorManager {
    private final int k;
    private final BlockingFloatHeap globalScoreQueue;

    public TopKnnCollectorManager(int k, IndexSearcher indexSearcher) {
        boolean isMultiSegments = indexSearcher.getIndexReader().leaves().size() > 1;
        this.k = k;
        this.globalScoreQueue = isMultiSegments ? new BlockingFloatHeap(k) : null;
    }

    @Override
    public KnnCollector newCollector(int visitedLimit, LeafReaderContext context) throws IOException {
        if (this.globalScoreQueue == null) {
            return new TopKnnCollector(this.k, visitedLimit);
        }
        return new MultiLeafKnnCollector(this.k, this.globalScoreQueue, new TopKnnCollector(this.k, visitedLimit));
    }
}

