/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.hnsw.HnswGraphProvider;
import guideme.internal.shaded.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.internal.hppc.IntIntHashMap;
import guideme.internal.shaded.lucene.util.BitSet;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.InfoStream;
import guideme.internal.shaded.lucene.util.hnsw.HnswBuilder;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraphBuilder;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraphMerger;
import guideme.internal.shaded.lucene.util.hnsw.InitializedHnswGraphBuilder;
import guideme.internal.shaded.lucene.util.hnsw.OnHeapHnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;

public class IncrementalHnswGraphMerger
implements HnswGraphMerger {
    protected final FieldInfo fieldInfo;
    protected final RandomVectorScorerSupplier scorerSupplier;
    protected final int M;
    protected final int beamWidth;
    protected KnnVectorsReader initReader;
    protected MergeState.DocMap initDocMap;
    protected int initGraphSize;

    public IncrementalHnswGraphMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth) {
        this.fieldInfo = fieldInfo;
        this.scorerSupplier = scorerSupplier;
        this.M = M;
        this.beamWidth = beamWidth;
    }

    @Override
    public IncrementalHnswGraphMerger addReader(KnnVectorsReader reader, MergeState.DocMap docMap, Bits liveDocs) throws IOException {
        KnnVectorsReader currKnnVectorsReader = reader;
        if (reader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)reader;
            currKnnVectorsReader = candidateReader.getFieldReader(this.fieldInfo.name);
        }
        if (!(currKnnVectorsReader instanceof HnswGraphProvider) || !IncrementalHnswGraphMerger.noDeletes(liveDocs)) {
            return this;
        }
        int candidateVectorCount = 0;
        switch (this.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                ByteVectorValues byteVectorValues = currKnnVectorsReader.getByteVectorValues(this.fieldInfo.name);
                if (byteVectorValues == null) {
                    return this;
                }
                candidateVectorCount = byteVectorValues.size();
                break;
            }
            case FLOAT32: {
                FloatVectorValues vectorValues = currKnnVectorsReader.getFloatVectorValues(this.fieldInfo.name);
                if (vectorValues == null) {
                    return this;
                }
                candidateVectorCount = vectorValues.size();
            }
        }
        if (candidateVectorCount > this.initGraphSize) {
            this.initReader = currKnnVectorsReader;
            this.initDocMap = docMap;
            this.initGraphSize = candidateVectorCount;
        }
        return this;
    }

    protected HnswBuilder createBuilder(KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        if (this.initReader == null) {
            return HnswGraphBuilder.create(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.randSeed, maxOrd);
        }
        HnswGraph initializerGraph = ((HnswGraphProvider)((Object)this.initReader)).getGraph(this.fieldInfo.name);
        FixedBitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorValues, initializedNodes);
        return InitializedHnswGraphBuilder.fromGraph(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.randSeed, initializerGraph, oldToNewOrdinalMap, initializedNodes, maxOrd);
    }

    @Override
    public OnHeapHnswGraph merge(KnnVectorValues mergedVectorValues, InfoStream infoStream, int maxOrd) throws IOException {
        HnswBuilder builder = this.createBuilder(mergedVectorValues, maxOrd);
        builder.setInfoStream(infoStream);
        return builder.build(maxOrd);
    }

    protected final int[] getNewOrdMapping(KnnVectorValues mergedVectorValues, BitSet initializedNodes) throws IOException {
        KnnVectorValues.DocIndexIterator initializerIterator = null;
        switch (this.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                initializerIterator = this.initReader.getByteVectorValues(this.fieldInfo.name).iterator();
                break;
            }
            case FLOAT32: {
                initializerIterator = this.initReader.getFloatVectorValues(this.fieldInfo.name).iterator();
            }
        }
        IntIntHashMap newIdToOldOrdinal = new IntIntHashMap(this.initGraphSize);
        int maxNewDocID = -1;
        int docId = initializerIterator.nextDoc();
        while (docId != Integer.MAX_VALUE) {
            int newId = this.initDocMap.get(docId);
            maxNewDocID = Math.max(newId, maxNewDocID);
            newIdToOldOrdinal.put(newId, initializerIterator.index());
            docId = initializerIterator.nextDoc();
        }
        if (maxNewDocID == -1) {
            return new int[0];
        }
        int[] oldToNewOrdinalMap = new int[this.initGraphSize];
        KnnVectorValues.DocIndexIterator mergedVectorIterator = mergedVectorValues.iterator();
        int newDocId = mergedVectorIterator.nextDoc();
        while (newDocId <= maxNewDocID) {
            int hashDocIndex = newIdToOldOrdinal.indexOf(newDocId);
            if (newIdToOldOrdinal.indexExists(hashDocIndex)) {
                int newOrd = mergedVectorIterator.index();
                initializedNodes.set(newOrd);
                oldToNewOrdinalMap[newIdToOldOrdinal.indexGet((int)hashDocIndex)] = newOrd;
            }
            newDocId = mergedVectorIterator.nextDoc();
        }
        return oldToNewOrdinalMap;
    }

    private static boolean noDeletes(Bits liveDocs) {
        if (liveDocs == null) {
            return true;
        }
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            return false;
        }
        return true;
    }
}

