/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> void splice(List<T> list, int start, int remove) {
        int removeEnd = Math.min(list.size(), start + remove);
        List<T> sublist = list.subList(start, removeEnd);
        sublist.clear();
    }

    public static <T> void splice(List<T> list, int start, int remove, List<T> items) {
        int removeEnd = Math.min(list.size(), start + remove);
        List<T> sublist = list.subList(start, removeEnd);
        sublist.clear();
        sublist.addAll(items);
    }

    public static <T> List<T> push(List<T> list, List<T> items) {
        list.addAll(items);
        return list;
    }

    public static <T> List<T> slice(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static <T> List<T> slice(List<T> list, int start) {
        return ListUtils.slice(list, start, list.size());
    }

    public static <T> List<T> slice(List<T> list, int start, int end) {
        if (start > list.size() || end <= start) {
            return new ArrayList();
        }
        end = Math.min(list.size(), end);
        return new ArrayList<T>(list.subList(start, end));
    }

    public static <T> void setLength(List<T> list, int newLength) {
        if (newLength <= 0) {
            list.clear();
        } else if (newLength < list.size()) {
            list.subList(newLength, list.size()).clear();
        }
    }

    @Nullable
    public static <T> T pop(List<T> listStack) {
        if (listStack.isEmpty()) {
            return null;
        }
        return listStack.remove(listStack.size() - 1);
    }
}

