/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Preprocessor {
    private static final Pattern SEARCH = Pattern.compile("[\u0000\t\n\r]");

    private Preprocessor() {
    }

    public static List<Object> preprocess(String value, boolean end) {
        int column = 1;
        String buffer = "";
        boolean start = true;
        boolean atCarriageReturn = false;
        ArrayList<Object> chunks = new ArrayList<Object>();
        value = buffer + (String)value;
        int startPosition = 0;
        buffer = "";
        if (start) {
            if (((String)value).length() > 0 && ((String)value).charAt(0) == '\ufeff') {
                ++startPosition;
            }
            start = false;
        }
        Matcher matcher = SEARCH.matcher((CharSequence)value);
        while (startPosition < ((String)value).length()) {
            boolean foundMatch = matcher.find(startPosition);
            if (!foundMatch) {
                buffer = ((String)value).substring(startPosition);
                break;
            }
            int endPosition = matcher.start();
            char code = ((String)value).charAt(endPosition);
            if (code == '\n' && startPosition == endPosition && atCarriageReturn) {
                chunks.add(-3);
                atCarriageReturn = false;
            } else {
                if (atCarriageReturn) {
                    chunks.add(-5);
                    atCarriageReturn = false;
                }
                if (startPosition < endPosition) {
                    chunks.add(((String)value).substring(startPosition, endPosition));
                    column += endPosition - startPosition;
                }
                switch (code) {
                    case '\u0000': {
                        chunks.add(65533);
                        ++column;
                        break;
                    }
                    case '\t': {
                        int next = (column + 3) / 4 * 4;
                        chunks.add(-2);
                        while (column++ < next) {
                            chunks.add(-1);
                        }
                        break;
                    }
                    case '\n': {
                        chunks.add(-4);
                        column = 1;
                        break;
                    }
                    default: {
                        atCarriageReturn = true;
                        column = 1;
                    }
                }
            }
            startPosition = endPosition + 1;
        }
        if (end) {
            if (atCarriageReturn) {
                chunks.add(-5);
            }
            if (!buffer.isEmpty()) {
                chunks.add(buffer);
            }
            chunks.add(Integer.MIN_VALUE);
        }
        return chunks;
    }
}

