/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;
import java.util.List;

public final class HeadingAtx {
    public static final Construct headingAtx = new Construct();

    private HeadingAtx() {
    }

    private static List<Tokenizer.Event> resolveHeadingAtx(List<Tokenizer.Event> events, TokenizeContext context) {
        int contentEnd = events.size() - 2;
        int contentStart = 3;
        if (events.get((int)contentStart).token().type.equals("whitespace")) {
            contentStart += 2;
        }
        if (contentEnd - 2 > contentStart && events.get((int)contentEnd).token().type.equals("whitespace")) {
            contentEnd -= 2;
        }
        if (events.get((int)contentEnd).token().type.equals("atxHeadingSequence") && (contentStart == contentEnd - 1 || contentEnd - 4 > contentStart && events.get((int)(contentEnd - 2)).token().type.equals("whitespace"))) {
            contentEnd -= contentStart + 1 == contentEnd ? 2 : 4;
        }
        if (contentEnd > contentStart) {
            Token content = new Token();
            content.type = "atxHeadingText";
            content.start = events.get((int)contentStart).token().start;
            content.end = events.get((int)contentEnd).token().end;
            Token text = new Token();
            text.type = "chunkText";
            text.start = events.get((int)contentStart).token().start;
            text.end = events.get((int)contentEnd).token().end;
            text.contentType = ContentType.TEXT;
            ListUtils.splice(events, contentStart, contentEnd - contentStart + 1, List.of(Tokenizer.Event.enter(content, context), Tokenizer.Event.enter(text, context), Tokenizer.Event.exit(text, context), Tokenizer.Event.exit(content, context)));
        }
        return events;
    }

    static {
        HeadingAtx.headingAtx.name = "headingAtx";
        HeadingAtx.headingAtx.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        HeadingAtx.headingAtx.resolve = HeadingAtx::resolveHeadingAtx;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        private int size;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 35, "expected `#`");
            this.effects.enter("atxHeading");
            this.effects.enter("atxHeadingSequence");
            return this.fenceOpenInside(code);
        }

        private State fenceOpenInside(int code) {
            if (code == 35 && this.size++ < 6) {
                this.effects.consume(code);
                return this::fenceOpenInside;
            }
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEndingOrSpace(code)) {
                this.effects.exit("atxHeadingSequence");
                return this.context.isInterrupt() ? this.ok.step(code) : this.headingBreak(code);
            }
            return this.nok.step(code);
        }

        private State headingBreak(int code) {
            if (code == 35) {
                this.effects.enter("atxHeadingSequence");
                return this.sequence(code);
            }
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("atxHeading");
                return this.ok.step(code);
            }
            if (CharUtil.markdownSpace(code)) {
                return FactorySpace.create(this.effects, this::headingBreak, "whitespace").step(code);
            }
            this.effects.enter("atxHeadingText");
            return this.data(code);
        }

        private State sequence(int code) {
            if (code == 35) {
                this.effects.consume(code);
                return this::sequence;
            }
            this.effects.exit("atxHeadingSequence");
            return this.headingBreak(code);
        }

        private State data(int code) {
            if (code == Integer.MIN_VALUE || code == 35 || CharUtil.markdownLineEndingOrSpace(code)) {
                this.effects.exit("atxHeadingText");
                return this.headingBreak(code);
            }
            this.effects.consume(code);
            return this::data;
        }
    }
}

