/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.entity;

import com.demonwav.mcdev.annotations.CheckEnv;
import com.demonwav.mcdev.annotations.Env;
import com.mojang.datafixers.util.Unit;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.ApiStatus;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.component.sync.C2SComponentPacketWriter;
import org.ladysnake.cca.internal.base.ComponentUpdatePayload;
import org.ladysnake.cca.internal.entity.CardinalComponentsEntity;

@ApiStatus.Experimental
public interface C2SSelfMessagingComponent
extends Component {
    public void handleC2SMessage(RegistryFriendlyByteBuf var1);

    @CheckEnv(value=Env.CLIENT)
    default public void sendC2SMessage(C2SComponentPacketWriter writer) {
        ComponentProvider provider = (ComponentProvider)Objects.requireNonNull(Minecraft.getInstance().player);
        ComponentKey key = Objects.requireNonNull(provider.getComponentContainer().getKey((Component)this));
        C2SSelfMessagingComponent.sendC2SMessage(key, writer);
    }

    @CheckEnv(value=Env.CLIENT)
    public static void sendC2SMessage(ComponentKey<?> key, C2SComponentPacketWriter writer) {
        PacketSender sender = ClientPlayNetworking.getSender();
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)PacketByteBufs.create(), (RegistryAccess)Objects.requireNonNull(Minecraft.getInstance().getConnection()).registryAccess());
        buf.writeResourceLocation(key.getId());
        writer.writeC2SPacket(buf);
        sender.sendPacket((CustomPacketPayload)new ComponentUpdatePayload(CardinalComponentsEntity.C2S_SELF_PACKET_ID, (Object)Unit.INSTANCE, true, key.getId(), buf), PacketSendListener.thenRun(() -> ((RegistryFriendlyByteBuf)buf).release()));
    }
}

