/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.CopyableComponent;
import org.ladysnake.cca.internal.entity.CardinalEntityInternals;

@FunctionalInterface
public interface RespawnCopyStrategy<C extends Component> {
    public static final RespawnCopyStrategy<Component> ALWAYS_COPY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> RespawnCopyStrategy.copy(from, to, registryLookup);
    public static final RespawnCopyStrategy<Component> CHARACTER = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {
        if (sameCharacter) {
            RespawnCopyStrategy.copy(from, to, registryLookup);
        }
    };
    public static final RespawnCopyStrategy<Component> INVENTORY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {
        if (lossless || keepInventory) {
            RespawnCopyStrategy.copy(from, to, registryLookup);
        }
    };
    public static final RespawnCopyStrategy<Component> LOSSLESS_ONLY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {
        if (lossless) {
            RespawnCopyStrategy.copy(from, to, registryLookup);
        }
    };
    public static final RespawnCopyStrategy<Component> NEVER_COPY = (from, to, registryLookup, lossless, keepInventory, sameCharacter) -> {};
    public static final ResourceLocation EVENT_PHASE = ResourceLocation.fromNamespaceAndPath((String)"cardinal-components", (String)"component-copy");

    public static <C extends Component> RespawnCopyStrategy<? super C> get(ComponentKey<C> key, Class<? extends LivingEntity> entityClass) {
        return CardinalEntityInternals.getRespawnCopyStrategy(key, entityClass);
    }

    public static <C extends Component> void copy(C from, C to, HolderLookup.Provider registryLookup) {
        if (to instanceof CopyableComponent) {
            CopyableComponent copyable = (CopyableComponent)to;
            CardinalEntityInternals.copyAsCopyable(from, copyable, registryLookup);
        } else {
            CompoundTag tag = new CompoundTag();
            from.writeToNbt(tag, registryLookup);
            to.readFromNbt(tag, registryLookup);
        }
    }

    public void copyForRespawn(C var1, C var2, HolderLookup.Provider var3, boolean var4, boolean var5, boolean var6);
}

