/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.api.v3.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.CopyableComponent;

@ApiStatus.Experimental
public interface RespawnableComponent<C extends Component>
extends Component,
CopyableComponent<C> {
    @Contract(pure=true)
    default public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory, boolean sameCharacter) {
        return lossless;
    }

    default public void copyForRespawn(C original, HolderLookup.Provider registryLookup, boolean lossless, boolean keepInventory, boolean sameCharacter) {
        this.copyFrom(original, registryLookup);
    }

    default public void copyFrom(C other, HolderLookup.Provider registryLookup) {
        CompoundTag tag = new CompoundTag();
        other.writeToNbt(tag, registryLookup);
        this.readFromNbt(tag, registryLookup);
    }
}

