/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.cca.internal.entity;

import com.mojang.datafixers.util.Unit;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentProvider;
import org.ladysnake.cca.api.v3.entity.C2SSelfMessagingComponent;
import org.ladysnake.cca.api.v3.entity.PlayerSyncCallback;
import org.ladysnake.cca.api.v3.entity.RespawnCopyStrategy;
import org.ladysnake.cca.api.v3.entity.TrackingStartCallback;
import org.ladysnake.cca.internal.base.ComponentUpdatePayload;
import org.ladysnake.cca.internal.base.ComponentsInternals;
import org.ladysnake.cca.internal.base.MorePacketCodecs;
import org.ladysnake.cca.internal.entity.StaticEntityComponentPlugin;
import org.ladysnake.cca.internal.entity.SwitchablePlayerEntity;

public final class CardinalComponentsEntity {
    public static final CustomPacketPayload.Type<ComponentUpdatePayload<Integer>> PACKET_ID = ComponentUpdatePayload.id((String)"entity_sync");
    public static final CustomPacketPayload.Type<ComponentUpdatePayload<Unit>> C2S_SELF_PACKET_ID = ComponentUpdatePayload.id((String)"player_message_c2s");
    private static final Set<ResourceLocation> unknownC2SPlayerComponents = new HashSet<ResourceLocation>();

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            ComponentUpdatePayload.register(PACKET_ID, (StreamCodec)ByteBufCodecs.VAR_INT);
            PayloadTypeRegistry.playC2S().register(C2S_SELF_PACKET_ID, ComponentUpdatePayload.codec(C2S_SELF_PACKET_ID, (StreamCodec)MorePacketCodecs.EMPTY));
            PlayerSyncCallback.EVENT.register(player -> CardinalComponentsEntity.syncEntityComponents(player, (Entity)player));
            TrackingStartCallback.EVENT.register(CardinalComponentsEntity::syncEntityComponents);
            ServerPlayNetworking.registerGlobalReceiver(C2S_SELF_PACKET_ID, (payload, ctx) -> {
                try {
                    Optional componentKey = payload.componentKey();
                    if (componentKey.isPresent()) {
                        Component patt0$temp = ((ComponentKey)componentKey.get()).getNullable((Object)ctx.player());
                        if (patt0$temp instanceof C2SSelfMessagingComponent) {
                            C2SSelfMessagingComponent synced = (C2SSelfMessagingComponent)patt0$temp;
                            synced.handleC2SMessage(payload.buf());
                        } else if (payload.required() && (unknownC2SPlayerComponents.add(payload.componentKeyId()) || FabricLoader.getInstance().isDevelopmentEnvironment())) {
                            ComponentsInternals.LOGGER.warn("[Cardinal Components API] Received an update for component {} from player {}, but this component is not registered for player entities", (Object)payload.componentKeyId(), (Object)ctx.player());
                        }
                    } else if (payload.required() && (unknownC2SPlayerComponents.add(payload.componentKeyId()) || FabricLoader.getInstance().isDevelopmentEnvironment())) {
                        ComponentsInternals.LOGGER.warn("[Cardinal Components API] Received an update for unknown component {} from player {}", (Object)payload.componentKeyId(), (Object)ctx.player());
                    }
                }
                finally {
                    payload.buf().release();
                }
            });
        }
        if (FabricLoader.getInstance().isModLoaded("fabric-lifecycle-events-v1")) {
            ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> ((ComponentProvider)entity).getComponentContainer().onServerLoad());
            ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> ((ComponentProvider)entity).getComponentContainer().onServerUnload());
        }
        ServerLivingEntityEvents.MOB_CONVERSION.register(RespawnCopyStrategy.EVENT_PHASE, CardinalComponentsEntity::copyData);
        ServerPlayerEvents.COPY_FROM.register(RespawnCopyStrategy.EVENT_PHASE, CardinalComponentsEntity::copyData);
        StaticEntityComponentPlugin.INSTANCE.ensureInitialized();
    }

    private static void copyData(LivingEntity original, LivingEntity clone, boolean keepInventory) {
        Set keys = ((ComponentProvider)original).getComponentContainer().keys();
        for (ComponentKey key : keys) {
            if (!key.isProvidedBy((Object)clone)) continue;
            CardinalComponentsEntity.copyData(original, clone, (HolderLookup.Provider)original.registryAccess(), false, keepInventory, true, key);
        }
    }

    private static void copyData(ServerPlayer original, ServerPlayer clone, boolean lossless) {
        boolean keepInventory = original.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || clone.isSpectator();
        Set keys = ((ComponentProvider)original).getComponentContainer().keys();
        for (ComponentKey key : keys) {
            CardinalComponentsEntity.copyData((LivingEntity)original, (LivingEntity)clone, (HolderLookup.Provider)original.registryAccess(), lossless, keepInventory, !((SwitchablePlayerEntity)original).cca$isSwitchingCharacter(), key);
        }
    }

    private static <C extends Component> void copyData(LivingEntity original, LivingEntity clone, HolderLookup.Provider registryLookup, boolean lossless, boolean keepInventory, boolean sameCharacter, ComponentKey<C> key) {
        Component from = key.get((Object)original);
        Component to = key.get((Object)clone);
        RespawnCopyStrategy.get(key, original.getClass()).copyForRespawn(from, to, registryLookup, lossless, keepInventory, sameCharacter);
    }

    private static void syncEntityComponents(ServerPlayer player, Entity tracked) {
        ComponentProvider provider = (ComponentProvider)tracked;
        for (ComponentKey key : provider.getComponentContainer().keys()) {
            key.syncWith(player, provider);
        }
    }
}

